/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus;

import com.gridnine.xtrip.client.fx.bus.entity.handlers.BusProductFXHelper;
import com.gridnine.xtrip.client.fx.bus.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.common.fx.bus.model.uidata.BusProductUIData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.util.MiscUtil;

enum BusFactoryTools implements FactoryTool
{
    BUS_TICKET{

        public String getName() {
            return Messages.bus_Product;
        }

        public double getWeight() {
            return 90.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<BusProduct, BusProductUIData> prototypeData = BusProductFXHelper.getPrototypeData();
                BusProduct product = (BusProduct)prototypeData.getFirst();
                BusProductUIData productSupplementData = (BusProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, (boolean)false);
        }
    };


    public String getUid() {
        return "bus-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.BOOKINGS;
    }

    public boolean isAuxiliary() {
        return false;
    }
}

