/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class DictionaryVersion
extends BaseAsset {
    private static final long serialVersionUID = 4422674856185006554L;
    private Date created;
    private Date modified;
    private String createdBy;
    private String modifiedBy;
    private String dataSource;
    private String versionNotes;
    private String dictId;
    private String code;
    private byte[] data;

    public DictionaryVersion() {
    }

    public DictionaryVersion(String uid) {
        super(uid);
    }

    public DictionaryVersion(BaseDictionary dict) throws Exception {
        this.created = dict.getModified();
        this.createdBy = dict.getModifiedBy();
        this.modified = dict.getModified();
        this.modifiedBy = dict.getModifiedBy();
        this.dataSource = dict.getDataSource();
        this.versionNotes = dict.getVersionNotes();
        this.dictId = dict.getClass().getName();
        this.code = dict.getCode();
        this.data = GZIPUtil.gzip((byte[])XSUtil.toByteArray((XSSerializable)dict));
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getVersionNotes() {
        return this.versionNotes;
    }

    public void setVersionNotes(String versionNotes) {
        this.versionNotes = versionNotes;
    }

    public String getDictId() {
        return this.dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.created = XHelper.readDate((Element)elm, (String)"created");
        this.modified = XHelper.readDate((Element)elm, (String)"modified");
        this.createdBy = XHelper.readString((Element)elm, (String)"createdBy");
        this.modifiedBy = XHelper.readString((Element)elm, (String)"modifiedBy");
        this.dataSource = XHelper.readString((Element)elm, (String)"dataSource");
        this.versionNotes = XHelper.readString((Element)elm, (String)"versionNotes");
        this.dictId = XHelper.readString((Element)elm, (String)"dictId");
        this.code = XHelper.readString((Element)elm, (String)"code");
        this.data = XHelper.readBytes((Element)elm, (String)"data");
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("created".equals(tagName)) {
            this.created = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("modified".equals(tagName)) {
            this.modified = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("createdBy".equals(tagName)) {
            this.createdBy = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("modifiedBy".equals(tagName)) {
            this.modifiedBy = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("dataSource".equals(tagName)) {
            this.dataSource = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("versionNotes".equals(tagName)) {
            this.versionNotes = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("dictId".equals(tagName)) {
            this.dictId = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("code".equals(tagName)) {
            this.code = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("data".equals(tagName)) {
            this.data = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeDate((Element)elm, (String)"created", (Date)this.created);
        XHelper.writeDate((Element)elm, (String)"modified", (Date)this.modified);
        XHelper.writeString((Element)elm, (String)"createdBy", (String)this.createdBy);
        XHelper.writeString((Element)elm, (String)"modifiedBy", (String)this.modifiedBy);
        XHelper.writeString((Element)elm, (String)"dataSource", (String)this.dataSource);
        XHelper.writeString((Element)elm, (String)"versionNotes", (String)this.versionNotes);
        XHelper.writeString((Element)elm, (String)"dictId", (String)this.dictId);
        XHelper.writeString((Element)elm, (String)"code", (String)this.code);
        XHelper.writeBytes((Element)elm, (String)"data", (byte[])this.data);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"created", (Date)this.created);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"modified", (Date)this.modified);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"createdBy", (String)this.createdBy);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"modifiedBy", (String)this.modifiedBy);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"dataSource", (String)this.dataSource);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"versionNotes", (String)this.versionNotes);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"dictId", (String)this.dictId);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"code", (String)this.code);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"data", (byte[])this.data);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        DictionaryVersion source = (DictionaryVersion)sourceAsset;
        this.created = XCloneHelper.cloneDate((Date)source.created);
        this.modified = XCloneHelper.cloneDate((Date)source.modified);
        this.createdBy = source.createdBy;
        this.modifiedBy = source.modifiedBy;
        this.dataSource = source.dataSource;
        this.versionNotes = source.versionNotes;
        this.dictId = source.dictId;
        this.code = source.code;
        this.data = (byte[])XCloneHelper.cloneArray((Object)source.data, (boolean)newUids, uids);
    }

    public static enum Property {
        created,
        modified,
        createdBy,
        modifiedBy,
        dataSource,
        versionNotes,
        dictId,
        code;

    }
}

