/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class SysLogItem
extends BaseAsset {
    private static final long serialVersionUID = 3799438236593158166L;
    private EventType type;
    private Date date;
    private String referenceType;
    private String referenceUid;
    private String referenceCaption;
    private String user;
    private String tag;
    private Message message;
    private String valueOld;
    private String valueNew;
    private double metricValue;

    public SysLogItem() {
    }

    public SysLogItem(String uid) {
        super(uid);
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType value) {
        this.type = value;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date value) {
        this.date = value;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String value) {
        this.referenceType = value;
    }

    public String getReferenceUid() {
        return this.referenceUid;
    }

    public void setReferenceUid(String value) {
        this.referenceUid = value;
    }

    public String getReferenceCaption() {
        return this.referenceCaption;
    }

    public void setReferenceCaption(String value) {
        this.referenceCaption = value;
    }

    public void setReference(EntityReference<?> ref) {
        if (ref == null) {
            this.referenceType = null;
            this.referenceUid = null;
            this.referenceCaption = null;
        } else {
            this.referenceType = ref.getType().getName();
            this.referenceUid = ref.getUid();
            this.referenceCaption = ref.getCaption();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String value) {
        this.tag = value;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message value) {
        this.message = value;
    }

    public String getValueOld() {
        return this.valueOld;
    }

    public void setValueOld(String value) {
        this.valueOld = value;
    }

    public String getValueNew() {
        return this.valueNew;
    }

    public void setValueNew(String value) {
        this.valueNew = value;
    }

    public double getMetricValue() {
        return this.metricValue;
    }

    public void setMetricValue(double value) {
        this.metricValue = value;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.type = (EventType)XHelper.readEnum((Element)elm, (String)"type", EventType.class);
        this.date = XHelper.readDate((Element)elm, (String)"date");
        this.referenceType = XHelper.readString((Element)elm, (String)"referenceType");
        this.referenceUid = XHelper.readString((Element)elm, (String)"referenceUid");
        this.referenceCaption = XHelper.readString((Element)elm, (String)"referenceCaption");
        this.user = XHelper.readString((Element)elm, (String)"user");
        this.tag = XHelper.readString((Element)elm, (String)"tag");
        Element messageElm = XmlUtil.getElement((Element)elm, (String)"message");
        if (messageElm != null) {
            this.message = new Message();
            this.message.fromXML(messageElm);
        } else {
            this.message = null;
        }
        this.valueOld = XHelper.readString((Element)elm, (String)"valueOld");
        this.valueNew = XHelper.readString((Element)elm, (String)"valueNew");
        this.metricValue = XHelper.readDouble((Element)elm, (String)"metricValue", (double)0.0);
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("type".equals(tagName)) {
            this.type = (EventType)XSHelper.readEnum((XMLStreamReader)reader, EventType.class);
            return true;
        }
        if ("date".equals(tagName)) {
            this.date = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("referenceType".equals(tagName)) {
            this.referenceType = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("referenceUid".equals(tagName)) {
            this.referenceUid = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("referenceCaption".equals(tagName)) {
            this.referenceCaption = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("user".equals(tagName)) {
            this.user = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("tag".equals(tagName)) {
            this.tag = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("message".equals(tagName)) {
            this.message = new Message();
            this.message.fromXML(reader);
            return true;
        }
        if ("valueOld".equals(tagName)) {
            this.valueOld = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("valueNew".equals(tagName)) {
            this.valueNew = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("metricValue".equals(tagName)) {
            this.metricValue = XSHelper.readDouble((XMLStreamReader)reader, (double)0.0);
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeEnum((Element)elm, (String)"type", (Enum)this.type);
        XHelper.writeDate((Element)elm, (String)"date", (Date)this.date);
        XHelper.writeString((Element)elm, (String)"referenceType", (String)this.referenceType);
        XHelper.writeString((Element)elm, (String)"referenceUid", (String)this.referenceUid);
        XHelper.writeString((Element)elm, (String)"referenceCaption", (String)this.referenceCaption);
        XHelper.writeString((Element)elm, (String)"user", (String)this.user);
        XHelper.writeString((Element)elm, (String)"tag", (String)this.tag);
        if (this.message != null) {
            this.message.toXML(XmlUtil.addElement((Element)elm, (String)"message"));
        }
        XHelper.writeString((Element)elm, (String)"valueOld", (String)this.valueOld);
        XHelper.writeString((Element)elm, (String)"valueNew", (String)this.valueNew);
        XHelper.writeDouble((Element)elm, (String)"metricValue", (double)this.metricValue);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"type", (Enum)this.type);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"date", (Date)this.date);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"referenceType", (String)this.referenceType);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"referenceUid", (String)this.referenceUid);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"referenceCaption", (String)this.referenceCaption);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"user", (String)this.user);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"tag", (String)this.tag);
        if (this.message != null) {
            writer.writeStartElement("message");
            this.message.toXML(writer);
            writer.writeEndElement();
        }
        XSHelper.writeString((XMLStreamWriter)writer, (String)"valueOld", (String)this.valueOld);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"valueNew", (String)this.valueNew);
        XSHelper.writeDouble((XMLStreamWriter)writer, (String)"metricValue", (double)this.metricValue);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        SysLogItem source = (SysLogItem)sourceAsset;
        this.type = source.type;
        this.date = XCloneHelper.cloneDate((Date)source.date);
        this.referenceType = source.referenceType;
        this.referenceUid = source.referenceUid;
        this.referenceCaption = source.referenceCaption;
        this.user = source.user;
        this.tag = source.tag;
        this.message = (Message)XCloneHelper.cloneObject((Object)source.message, (boolean)newUids, uids);
        this.valueOld = source.valueOld;
        this.valueNew = source.valueNew;
        this.metricValue = source.metricValue;
    }

    public static enum EventType {
        AUDIT,
        MODIFICATION,
        METRIC;

    }

    public static enum Property {
        eventType,
        eventDate,
        referenceType,
        referenceUid,
        referenceCaption,
        eventUser,
        tag,
        messageType,
        valueOld,
        valueNew,
        metricValue;

    }
}

