/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.user.UserData;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserAccountTest {
    @Before
    public void prepare() {
        UserData tempUserData = new UserData(() -> "temp user");
        Environment.publish((Object)tempUserData);
    }

    @After
    public void tearDown() {
        Environment.unpublish(UserData.class);
    }

    @Test
    public void testPasswordValidation() throws Exception {
        Callable<byte[]> password = () -> UserAccount.digest("fake_password".toCharArray());
        Callable<byte[]> passwordOther = () -> UserAccount.digest("fake_password_OTHER".toCharArray());
        Callable<byte[]> ssoSalt = () -> UserAccount.digest("fake_SSO_salt".toCharArray());
        UserAccount account = new UserAccount();
        Assert.assertTrue((boolean)account.isPasswordValid((byte[])null));
        Assert.assertTrue((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setPasswordDigest(new byte[0]);
        Assert.assertTrue((boolean)account.isPasswordValid((byte[])null));
        Assert.assertTrue((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setSsoSaltDigest(new byte[0]);
        Assert.assertTrue((boolean)account.isPasswordValid((byte[])null));
        Assert.assertTrue((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setPasswordDigest(new byte[0]);
        account.setSsoSaltDigest(new byte[0]);
        Assert.assertTrue((boolean)account.isPasswordValid((byte[])null));
        Assert.assertTrue((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setPasswordDigest(password.call());
        Assert.assertFalse((boolean)account.isPasswordValid((byte[])null));
        Assert.assertFalse((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertTrue((boolean)account.isPasswordValid(password.call()));
        Assert.assertFalse((boolean)account.isPasswordValid(passwordOther.call()));
        account = new UserAccount();
        account.setPasswordDigest(password.call());
        account.setSsoSaltDigest(new byte[0]);
        Assert.assertFalse((boolean)account.isPasswordValid((byte[])null));
        Assert.assertFalse((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertTrue((boolean)account.isPasswordValid(password.call()));
        Assert.assertFalse((boolean)account.isPasswordValid(passwordOther.call()));
        account = new UserAccount();
        account.setSsoSaltDigest(ssoSalt.call());
        Assert.assertFalse((boolean)account.isPasswordValid((byte[])null));
        Assert.assertFalse((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setPasswordDigest(new byte[0]);
        account.setSsoSaltDigest(ssoSalt.call());
        Assert.assertFalse((boolean)account.isPasswordValid((byte[])null));
        Assert.assertFalse((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertFalse((boolean)account.isPasswordValid(password.call()));
        account = new UserAccount();
        account.setPasswordDigest(password.call());
        account.setSsoSaltDigest(ssoSalt.call());
        Assert.assertFalse((boolean)account.isPasswordValid((byte[])null));
        Assert.assertFalse((boolean)account.isPasswordValid(new byte[0]));
        Assert.assertTrue((boolean)account.isPasswordValid(password.call()));
        Assert.assertFalse((boolean)account.isPasswordValid(passwordOther.call()));
    }
}

