/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import java.util.regex.Pattern;

public final class PasswordHelper {
    public static final Pattern PATTERN_LETTER = Pattern.compile("[a-zA-Z]+");
    public static final Pattern PATTERN_LOWER = Pattern.compile("\\p{javaLowerCase}+");
    public static final Pattern PATTERN_UPPER = Pattern.compile("\\p{javaUpperCase}+");
    public static final Pattern PATTERN_NUM = Pattern.compile("\\d+");
    public static final Pattern PATTERN_SPECIAL = Pattern.compile("[\\D&&\\W&&\\S]+");

    public static int calculatePasswordStrength(String password) {
        int result = 0;
        if (password == null) {
            return result;
        }
        if (PATTERN_LOWER.matcher(password).find()) {
            ++result;
        }
        if (PATTERN_UPPER.matcher(password).find()) {
            ++result;
        }
        if (PATTERN_NUM.matcher(password).find()) {
            ++result;
        }
        if (PATTERN_SPECIAL.matcher(password).find()) {
            ++result;
        }
        if (password.length() >= 8) {
            ++result;
        }
        return result;
    }

    private PasswordHelper() {
    }
}

