/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoUpdateHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class ReservationGdsNameInfoHelper {
    public static String getOnlineRecordLocator(Reservation reservation, RecordLocatorType type) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocatorOptional(reservation, type).orElse(null);
    }

    public static Optional<String> getOnlineRecordLocatorOptional(Reservation reservation, RecordLocatorType type) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(gdsNameInfo.getOnlineGdsAccount());
        if (gdsAccountCtr == null) {
            return Optional.empty();
        }
        GdsName onlineGdsName = ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds();
        return CommonReservationGdsNameInfoHelper.getRecordLocatorOptional((Reservation)reservation, (GdsName)onlineGdsName, (RecordLocatorType)type);
    }

    public static boolean containsOnlineRecordLocatorOfAnyType(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(gdsNameInfo.getOnlineGdsAccount());
        if (gdsAccountCtr == null) {
            return false;
        }
        GdsName onlineGdsName = ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds();
        return gdsNameInfo.getSystemInfos().stream().filter(si -> si.getGdsName() == onlineGdsName).map(ReservationSystemInfo::getRecordLocators).flatMap(Collection::stream).map(RecordLocatorInfo::getRecordLocator).anyMatch(Objects::nonNull);
    }

    public static <T extends BaseGdsAccount> boolean hasOnlineGdsAccountOfClass(Reservation reservation, Class<T> clazz) {
        EntityReference onlineGdsAccount = reservation.getGdsNameInfo().getOnlineGdsAccount();
        if (onlineGdsAccount == null) {
            return false;
        }
        return clazz.equals(onlineGdsAccount.getType());
    }

    public static void setRulesGdsNameFromAccount(Reservation reservation, EntityReference<? extends BaseGdsAccount> gdsAccountRef) {
        ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount(reservation, (EntityContainer<? extends BaseGdsAccount>)EntityStorage.get().resolve(gdsAccountRef));
    }

    public static void setRulesGdsNameFromAccount(Reservation reservation, EntityContainer<? extends BaseGdsAccount> gdsAccountCtr) {
        if (gdsAccountCtr == null) {
            return;
        }
        reservation.getGdsNameInfo().setRulesGdsName(((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds());
    }

    public static void updateReservationGdsNameInfo(Reservation reservation) {
        ReservationGdsNameInfoUpdateHandler updateHandler = (ReservationGdsNameInfoUpdateHandler)Environment.getPublished(ReservationGdsNameInfoUpdateHandler.class);
        updateHandler.updateData(reservation);
    }
}

