/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class ReservationGdsNameInfoUpdateHandler {
    protected void updateData(Reservation reservation) {
        if (reservation.getGdsNameInfo().getRulesGdsName() == null) {
            reservation.getGdsNameInfo().setRulesGdsName(this.getCompatibilityGdsName(reservation));
        }
        if (reservation.getGdsNameInfo().getStatisticsGdsName() == null) {
            reservation.getGdsNameInfo().setStatisticsGdsName(this.getCompatibilityGdsName(reservation));
        }
        if (!ReservationGdsNameInfoUpdateHandler.hasRecordLocatorFlag(reservation, RecordLocatorInfo::isDisplay)) {
            ReservationGdsNameInfoUpdateHandler.setRecordLocatorFlag(reservation, this::isCompatibilityRecordLocator, RecordLocatorInfo::setDisplay);
        }
        if (!ReservationGdsNameInfoUpdateHandler.hasRecordLocatorFlag(reservation, RecordLocatorInfo::isExport1C)) {
            ReservationGdsNameInfoUpdateHandler.setRecordLocatorFlag(reservation, this::isCompatibilityRecordLocator, RecordLocatorInfo::setExport1C);
        }
    }

    private GdsName getCompatibilityGdsName(Reservation reservation) {
        return Optional.ofNullable(EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount())).map(EntityContainer::getEntity).map(BaseGdsAccount::getGds).orElseGet(() -> {
            Set systemInfoGdsNames = reservation.getGdsNameInfo().getSystemInfos().stream().map(ReservationSystemInfo::getGdsName).filter(Objects::nonNull).collect(Collectors.toSet());
            if (systemInfoGdsNames.size() == 1) {
                return (GdsName)systemInfoGdsNames.iterator().next();
            }
            return null;
        });
    }

    protected static boolean hasRecordLocatorFlag(Reservation reservation, Predicate<RecordLocatorInfo> flagPredicate) {
        return reservation.getGdsNameInfo().getSystemInfos().stream().map(ReservationSystemInfo::getRecordLocators).flatMap(Collection::stream).anyMatch(flagPredicate);
    }

    protected static void setRecordLocatorFlag(Reservation reservation, TPredicate<ReservationSystemInfo, RecordLocatorInfo, Reservation> recordLocatorInfoPredicate, BiConsumer<RecordLocatorInfo, Boolean> flagConsumer) {
        for (ReservationSystemInfo systemInfo : reservation.getGdsNameInfo().getSystemInfos()) {
            systemInfo.getRecordLocators().stream().filter(rli -> recordLocatorInfoPredicate.test(systemInfo, (RecordLocatorInfo)rli, reservation)).forEach(rli -> flagConsumer.accept((RecordLocatorInfo)rli, true));
        }
    }

    protected abstract boolean isCompatibilityRecordLocator(ReservationSystemInfo var1, RecordLocatorInfo var2, Reservation var3);

    @FunctionalInterface
    protected static interface TPredicate<A, B, C> {
        public boolean test(A var1, B var2, C var3);
    }
}

