/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.helper.StandardSalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SalesContextHandler {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public static final SalesContext superUserSalesCtx() {
        SalesContext result = new SalesContext();
        result.setAgent(SalesContextHandler.superUser());
        return result;
    }

    public static final EntityReference<Person> superUser() {
        return new EntityReference("SUPERUSER", Person.class, "superuser");
    }

    public static String describe(SalesContext salesContext) {
        if (salesContext == null) {
            return null;
        }
        return String.format("agency: %s, subagency: %s, client: %s", SalesContextHandler.describe((EntityReference<Organization>)salesContext.getAgency()), SalesContextHandler.describe((EntityReference<Organization>)salesContext.getSubagency()), SalesContextHandler.describe((EntityReference<Organization>)salesContext.getClient()));
    }

    public static String describe(EntityReference<Organization> ref) {
        if (ref == null) {
            return null;
        }
        return ref.getCaption() != null ? String.format("%s (uid=%s)", ref.getCaption(), ref.getUid()) : "uid=" + ref.getUid();
    }

    public static SalesContextHandler get() {
        if (!Environment.isPublished(SalesContextHandler.class)) {
            try {
                Environment.publish(SalesContextHandler.class, (Object)new StandardSalesContextHandler());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (SalesContextHandler)Environment.getPublished(SalesContextHandler.class);
    }

    public abstract EntityReference<Organization> getAgency(SalesContext var1);

    public abstract EntityReference<Organization> getClient(SalesContext var1);

    public abstract EntityReference<Organization> getAllClients();

    public abstract RuleSet getRules(SalesContext var1) throws Exception;

    public abstract void enforceSalesContext(SalesContext var1, Reservation var2);

    public abstract SalesContext createSalesContext(Reservation var1);

    public abstract EntityReference<Organization> getOnlineAgency(SalesPoint var1);
}

