<%/*****************************************************************
* Gridnine AB http://www.gridnine.com
* Project: Myreis
* Legal notice: (c) Gridnine AB. All rights reserved.
*****************************************************************/%>
<%@ page language="java"
    contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"
    import="java.util.*"
    import="java.math.*"
    import="com.gridnine.xtrip.common.util.TextUtil"
    import="com.gridnine.xtrip.common.Environment"
    import="java.text.SimpleDateFormat"
    import="java.text.NumberFormat"
    import="com.gridnine.xtrip.common.model.profile.Organization"
	import="com.gridnine.xtrip.common.model.profile.OrganizationIndex"
	import="com.gridnine.xtrip.common.model.EntityCache"
	import="com.gridnine.xtrip.common.model.EntityContainer"
	import="com.gridnine.xtrip.common.model.profile.Organization"
	import="com.gridnine.xtrip.common.model.profile.OrganizationIndex"
%>


<%@page import="com.gridnine.xtrip.common.gds.stat.GDSStatEntry"%><head><title>Детализация статистики по запросам</title></head>
<body>
<%
	Map<String,BigDecimal> requestCount = (Map<String,BigDecimal>)request.getSession().getAttribute("requestCount"+request.getParameter("gds"));
	Map<String,BigDecimal> totalPrice = (Map<String,BigDecimal>)request.getSession().getAttribute("totalPrice"+request.getParameter("gds"));
	Map<String,List<GDSStatEntry>> logsByPartner = (Map<String,List<GDSStatEntry>>)request.getSession().getAttribute("logsByPartner"+request.getParameter("gds"));
	Properties configFile = (Properties)request.getSession().getAttribute("configFile"+request.getParameter("gds"));
	String partnerId = request.getParameter("partnerId");
	List<GDSStatEntry> partnerLogs = logsByPartner.get(partnerId);
	SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.getDefault());
	SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS",Locale.getDefault());
	if (partnerLogs==null) {
		%><p>Неизвестный партнер</p><%
    } else {
	    String partnerName=partnerId;
    	EntityContainer<Organization> sa = Environment.getPublished(EntityStorage.class).find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), partnerId);
        if (sa!=null && sa.getEntity()!=null) {
        	partnerName = sa.getEntity().getShortName();
        }
%>
	<p>GDS: <%=request.getParameter("gds")%><br/>
	<p>Партнер: <%=TextUtil.isBlank(partnerName)?"Неизвестен":partnerName %><br/>
	Всего запросов: <%=requestCount.get(partnerId) %><br/>
    <% NumberFormat f = NumberFormat.getInstance();
   	   f.setGroupingUsed(false);
   	   f.setMinimumFractionDigits(5);
   	   BigDecimal value = totalPrice.get(partnerId);%>
       Сумма <%= "SABRE".equalsIgnoreCase(request.getParameter("gds"))?"центов":"баллов" %>: <%=f.format(value) %>
	<% if (request.getSession().getAttribute("from")!=null) { %>
		<br/>Дата начала отчётного периода: <%=request.getSession().getAttribute("from") %>
	<% } %>
	<% if (request.getSession().getAttribute("to")!=null) { %>
		<br/>Дата окончания отчётного периода: <%=request.getSession().getAttribute("to") %>
	<% } %>
	</p>
	<table border="1">
	   	<tr><th>Время</th><th>Тип запроса</th><th>Баллы</th></tr>
	    <%  for(GDSStatEntry entry : partnerLogs) {
	    		Date time = entry.getDate();
	    		for(String transactionName : entry.getTransactionNames()) {
	    			String price = transactionName;
		    		if ("SABRE".equals(request.getParameter("gds"))) {
						 Calendar c = Calendar.getInstance();
						 c.setTime(time);
						 String time_of_day;
						 if ((c.get(Calendar.HOUR_OF_DAY)>=1) && (c.get(Calendar.HOUR_OF_DAY)<18)) {
							 time_of_day="_day";
						 } else {
							 time_of_day="_night";
						 }
						 price+=time_of_day;
		    		} else {
		    			price = price.toLowerCase();
		    		}
				%><tr>
		    	    <td><%=df1.format(time)%></td>
		        	<td><%=transactionName%></td>
		        	<td><%=configFile.getProperty(price)%></td>
		        </tr>
	        <% } 
	        } %>
	</table>
 <% } %>
</body>