<%@ page
	pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"
	import="java.util.*"
	import="com.gridnine.bof.midoffice.ssl.KeyManager"
	import="java.security.KeyPair"
	import="com.gridnine.xtrip.common.util.Base64"
	import="com.gridnine.xtrip.common.util.TextUtil"
	import="com.gridnine.bof.midoffice.ssl.DatabaseSecurityHelper"
	import="java.security.MessageDigest"
	import="java.io.ByteArrayInputStream"
	import="java.io.ObjectInputStream"
%>

<%
	String thisUri = request.getRequestURI();
	KeyManager kman = KeyManager.getInstance();
	DatabaseSecurityHelper secHelper = DatabaseSecurityHelper.getInstance();
  	Map<String, KeyPair> keyMap =  kman.getKeyPairMap();




	String generate = request.getParameter("generate");
	String copy = request.getParameter("copy");
	String delete = request.getParameter("delete");
	String write = request.getParameter("write");

	if(!TextUtil.isBlank(generate)){
		String alias = request.getParameter("alias");
		String alg = request.getParameter("alg");
		Integer keysize = Integer.parseInt(request.getParameter("keysize"));
		kman.generate(alias, alg, keysize);
		response.sendRedirect(thisUri);
		return;
	}


	if(!TextUtil.isBlank(copy)){
		String from = request.getParameter("from");
		String to = request.getParameter("to");

		kman.copy(from, to);
		response.sendRedirect(thisUri);
		return;
	}


	if(!TextUtil.isBlank(delete)){
		String alias = request.getParameter("alias");
		kman.delete(alias);
		response.sendRedirect(thisUri);
		return;
	}

	if(!TextUtil.isBlank(write)){
		String alias = request.getParameter("key_alias");
		String data = request.getParameter("key_pair");
        ByteArrayInputStream in =
            new ByteArrayInputStream(Base64.decode(data));
        ObjectInputStream is = new ObjectInputStream(in);
        KeyPair kp = (KeyPair) is.readObject();
		kman.add(alias, kp);
		response.sendRedirect(thisUri);
		return;
	}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<title>Key Tool - <%= application.getServletContextName() %></title>

	<style type="text/css">


		table.keys-table{
			width:100%
		}

		table.keys-table td, th{
			border: thin solid black;
		}

	</style>


</head>

<body>


		<table class="keys-table" cellspacing="0" cellpadding="10">
			<tr>
				<th>Alias</th>
				<th>Alg.</th>
				<th>Public Key (Base64)</th>
				<th>Signature (Base64)</th>
				<th>Digest (Base64)</th>
				<%--  <th></th>  --%>
			</tr>

			<%
			java.util.List<String> lst = new java.util.LinkedList<String>(keyMap.keySet());
			java.util.Collections.sort(lst);
		  	for(final String alias : lst){
		  		KeyPair pair = keyMap.get(alias);
		  		byte[] data = pair.getPublic().getEncoded();
		  		byte[] signature = secHelper.sign(alias, "SHA1withRSA", data);
		  		byte[] digest = MessageDigest.getInstance("SHA-1").digest(data);

		  		%><tr>
		  			<td><%= alias %></td>
		  			<td><%= pair.getPublic().getAlgorithm() %></td>
		  			<td><%= Base64.encode(data) %></td>
		  			<td><%= Base64.encode(signature) %></td>
		  			<td><%= Base64.encode(digest) %></td>
		  		<%--	<td><a href="<%=thisUri %>?alias=<%= alias%>&delete=1">удалить</a></td> --%>
		  		</tr><%

		  	}

			%>

		</table>

	<form>
		<table>
			<tr>
				<td>Alias:</td><td><input name="alias" /></td>
			</tr>
			<tr>
				<td>Alg:</td><td>
					<select name="alg">
						<option value="RSA">RSA</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>Key Size:</td><td><input name="keysize" value="512"/></td>
			</tr>
		</table>
		<input type="submit" value="GENERATE"/>
		<input name="generate" type="hidden" value="1"/>
	</form>
	<hr>

	<form>
		<table>
			<tr>
				<td>Alias From:</td><td><input name="from" /></td>
			</tr>
			<tr>
				<td>Alias To:</td><td><input name="to" /></td>
			</tr>
		</table>
		<input type="submit" value="COPY"/>
		<input name="copy" type="hidden" value="1"/>
	</form>
	<hr>

	<form>
		<table>
			<tr>
				<td>Alias:</td><td><input name="alias" /></td>
			</tr>
		</table>
		<input type="submit" value="DELETE"/>
		<input name="delete" type="hidden" value="1"/>
	</form>
	<hr>

	<form>
		<table>
			<tr>
				<td>Alias:</td><td><input name="key_alias" /></td>
			</tr>
			<tr>
				<td>Data:</td><td><textarea name="key_pair"></textarea></td>
			</tr>
		</table>
		<input type="submit" value="WRITE"/>
		<input name="write" type="hidden" value="1"/>
	</form>

</body>
</html>
