<%@page import="java.util.Map.Entry"%>
<%@page import="java.util.Map"%>
<%@page import="org.apache.commons.lang.StringUtils"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData"%>
<%@page import="com.gridnine.xtrip.common.xml.XUtil"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData"%>
<%@page import="java.util.Iterator"%>
<%@page import="com.gridnine.xtrip.common.search.SortOrder"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="java.util.Date"%>
<%@page import="java.util.List"%>
<%@page import="com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterPhysicalStorage"%>
<%@page import="com.gridnine.xtrip.common.util.Base64"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession"%>
<%@page import="com.gridnine.xtrip.server.db.storage.replication.ReplicationPhysicalStorage"%>
<%@page import="com.gridnine.xtrip.server.db.storage.replication.masterindex.MasterIndexPhysicalStorage"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.PhysicalStorage"%>
<%@page import="com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="java.util.Enumeration"%>
<%!
public String render(boolean value) {
	return Boolean.toString(value);
}
public String renderStrings(List<String> value) {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	for (Iterator<String> iter = value.iterator(); iter.hasNext(); ) {
		sb.append(iter.next());
		if (iter.hasNext()) {
			sb.append("<br/>");
		}
	}
	return sb.toString();
}
public String renderVersions(List<PhysicalVersionData> value) {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	for (int i = 0; i < value.size(); i++) {
		PhysicalVersionData pvd = (PhysicalVersionData) value.get(i);
		sb.append(render(pvd, String.format("[%d]", Integer.valueOf(i))));
	}
	return sb.toString();
}
public String render(PhysicalAssetData value) throws Exception {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	sb.append("<h3>PhysicalAssetData</h3>");
	sb.append("<table border=\"1\">");
	sb.append("<tr><th>parameter</th><th>value</th></tr>");
	sb.append("<tr><td>asset</td><td>").append(XUtil.toString(value.getAsset())).append("</td></tr>");
	sb.append("</table>");
	return sb.toString();
}
public String render(PhysicalDictionaryData value) throws Exception {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	sb.append("<h3>PhysicalDictionaryData</h3>");
	sb.append("<table border=\"1\">");
	sb.append("<tr><th>parameter</th><th>value</th></tr>");
	sb.append("<tr><td>code</td><td>").append(value.getCode()).append("</td></tr>");
	sb.append("<tr><td>created</td><td>").append(value.getCreated()).append("</td></tr>");
	sb.append("<tr><td>data</td><td>").append(Base64.encode(value.getData())).append("</td></tr>");
	sb.append("<tr><td>deleted</td><td>").append(value.isDeleted()).append("</td></tr>");
	sb.append("<tr><td>dictionaryType</td><td>").append(value.getDictionaryType()).append("</td></tr>");
	sb.append("<tr><td>modified</td><td>").append(value.getModified()).append("</td></tr>");
	sb.append("<tr><td>uid</td><td>").append(value.getUid()).append("</td></tr>");
	sb.append("</table>");
	return sb.toString();
}
public String render(PhysicalEntityData value) {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	sb.append("<h3>PhysicalEntityData</h3>");
	sb.append("<table border=\"1\">");
	sb.append("<tr><th>parameter</th><th>value</th></tr>");
	sb.append("<tr><td>created</td><td>").append(value.getCreated()).append("</td></tr>");
	sb.append("<tr><td>createdBy</td><td>").append(value.getCreatedBy()).append("</td></tr>");
	sb.append("<tr><td>entityType</td><td>").append(value.getEntityType()).append("</td></tr>");
	sb.append("<tr><td>modified</td><td>").append(value.getModified()).append("</td></tr>");
	sb.append("<tr><td>modifiedBy</td><td>").append(value.getModifiedBy()).append("</td></tr>");
	sb.append("<tr><td>status</td><td>").append(value.getStatus()).append("</td></tr>");
	sb.append("<tr><td>uid</td><td>").append(value.getUid()).append("</td></tr>");
	sb.append("<tr><td>updatePolicy</td><td>").append(value.getUpdatePolicy()).append("</td></tr>");
	sb.append("<tr><td>versionsCount</td><td>").append(value.getVersionsCount()).append("</td></tr>");
	sb.append("</table>");
	sb.append(renderVersions(value.getVersions()));
	return sb.toString();
}
public String render(PhysicalVersionData value) {
	return render(value, null);
}
public String render(Map<String, String> value) {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	sb.append("<table border=\"1\">");
	sb.append("<tr><th>key</th><th>value</th></tr>");
	for (Entry<String, String> entry : value.entrySet()) {
		sb.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(entry.getValue()).append("</td></tr>");
	}
	sb.append("</table>");
	return sb.toString();
}
public String render(PhysicalVersionData value, String suffix) {
	if (value == null) {
		return "null";
	}
	StringBuilder sb = new StringBuilder();
	sb.append("<h3>PhysicalVersionData").append(suffix == null ? "" : suffix).append("</h3>");
	sb.append("<table border=\"1\">");
	sb.append("<tr><th>parameter</th><th>value</th></tr>");
	sb.append("<tr><td>created</td><td>").append(value.getCreated()).append("</td></tr>");
	sb.append("<tr><td>createdBy</td><td>").append(value.getCreatedBy()).append("</td></tr>");
	sb.append("<tr><td>data</td><td>").append(Base64.encode(value.getData())).append("</td></tr>");
	sb.append("<tr><td>dataFormat</td><td>").append(value.getDataFormat()).append("</td></tr>");
	sb.append("<tr><td>dataSource</td><td>").append(value.getDataSource()).append("</td></tr>");
	sb.append("<tr><td>modified</td><td>").append(value.getModified()).append("</td></tr>");
	sb.append("<tr><td>modifiedBy</td><td>").append(value.getModifiedBy()).append("</td></tr>");
	sb.append("<tr><td>uid</td><td>").append(value.getUid()).append("</td></tr>");
	sb.append("<tr><td>versionNotes</td><td>").append(value.getVersionNotes()).append("</td></tr>");
	sb.append("<tr><td>versionNumber</td><td>").append(value.getVersionNumber()).append("</td></tr>");
	sb.append("</table>");
	return sb.toString();
}
%>
<html>
<body>
<h2>Result</h2>
<%
MasterPhysicalStorage storage = null;
outer : for (PhysicalStorage ps : Environment.getPublished(LogicalStorageRegistry.class).getStorageList()) {
	if (ps instanceof MasterIndexPhysicalStorage) {
		storage = ((MasterIndexPhysicalStorage)ps).getMasterStorage();
		break outer;
	} else if (ps instanceof ReplicationPhysicalStorage) {
		for (PhysicalStorage ps2 : ((ReplicationPhysicalStorage)ps).getSubstorages()) {
			if (ps2 instanceof MasterIndexPhysicalStorage) {
				storage = ((MasterIndexPhysicalStorage)ps2).getMasterStorage();
				break outer;
			}
		}
	}
}
if (storage == null) {
	%><p>master-index storage not found</p><%
} else {
	PhysicalStorageSession ss = storage.createSession();
	ss.begin();
	try {
		String method = request.getParameter("method");
		if ("deleteAllEntities".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			storage.getEntityStorage().deleteAllEntities(cls, ss);
		} else if ("deleteEntity".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			PhysicalEntityData data = storage.getEntityStorage().loadEntity(cls, uid, null, ss);
			storage.getEntityStorage().deleteEntity(data, ss);
		} else if ("getEntityUids".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			Date startDate = StringUtils.isBlank(request.getParameter("startDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("startDate"));
			Date endDate = StringUtils.isBlank(request.getParameter("endDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("endDate"));
			boolean useCreateDate = Boolean.parseBoolean(request.getParameter("useCreateDate"));
			boolean ignoreVoid = Boolean.parseBoolean(request.getParameter("ignoreVoid"));
			SortOrder sortOrder = StringUtils.isBlank(request.getParameter("sortOrder")) ? null : SortOrder.valueOf(request.getParameter("sortOrder"));
			Integer limit = StringUtils.isBlank(request.getParameter("limit")) ? null : Integer.valueOf(request.getParameter("limit"));
			%><%= renderStrings(storage.getEntityStorage().getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, ss)) %><%
		} else if ("getVersions".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			PhysicalEntityData entityData = storage.getEntityStorage().loadEntity(cls, uid, null, ss);
			String vns = request.getParameter("versionNumbers");
			int[] versionNumbers;
			if (StringUtils.isBlank(vns)) {
				versionNumbers = new int[0];
			} else {
				String[] vnss = vns.split(",");
				versionNumbers = new int[vnss.length];
				for (int i = 0; i < vnss.length; i++) {
					versionNumbers[i] = Integer.parseInt(vnss[i]);
				}
			}
			%><%= renderVersions(storage.getEntityStorage().getVersions(entityData, ss, versionNumbers)) %><%
		} else if ("isEntityAvailable".equals(method)) {
			Class cls = Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			%><%= render(storage.getEntityStorage().isEntityAvailable(cls, uid, ss)) %><%
		} else if ("loadEntity".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			Integer versionNumber = StringUtils.isBlank(request.getParameter("versionNumber")) ? null : Integer.valueOf(request.getParameter("versionNumber"));
			%><%= render(storage.getEntityStorage().loadEntity(cls, uid, versionNumber, ss))%><%
		} else if ("deleteAsset".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			PhysicalAssetData asset = storage.getAssetStorage().loadAsset(cls, uid, ss);
			storage.getAssetStorage().deleteAsset(asset, ss);
		} else if ("getAssetUids".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			Date startDate = StringUtils.isBlank(request.getParameter("startDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("startDate"));
			Date endDate = StringUtils.isBlank(request.getParameter("endDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("endDate"));
			SortOrder sortOrder = StringUtils.isBlank(request.getParameter("sortOrder")) ? null : SortOrder.valueOf(request.getParameter("sortOrder"));
			Integer limit = StringUtils.isBlank(request.getParameter("limit")) ? null : Integer.valueOf(request.getParameter("limit"));
			%><%= renderStrings(storage.getAssetStorage().getAssetUids(cls, startDate, endDate, sortOrder, limit, ss)) %><%
		} else if ("loadAsset".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			%><%= render(storage.getAssetStorage().loadAsset(cls, uid, ss))%><%
		} else if ("deleteAll".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			storage.getDictionaryStorage().deleteAll(cls, ss);
		} else if ("deleteDictionary".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			boolean ignoreDeleted = Boolean.parseBoolean(request.getParameter("ignoreDeleted"));
			PhysicalDictionaryData data = storage.getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, ss);
			storage.getDictionaryStorage().deleteDictionary(data, ss);
		} else if ("findDictionaryByUid".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			String uid = request.getParameter("uid");
			boolean ignoreDeleted = Boolean.parseBoolean(request.getParameter("ignoreDeleted"));
			%><%= render(storage.getDictionaryStorage().findDictionaryByUid(cls, uid, ignoreDeleted, ss))%><%
		} else if ("getDictionaryUids".equals(method)) {
			Class cls = (Class)Class.forName(request.getParameter("cls"));
			Date startDate = StringUtils.isBlank(request.getParameter("startDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("startDate"));
			Date endDate = StringUtils.isBlank(request.getParameter("endDate")) ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(request.getParameter("endDate"));
			boolean useCreateDate = Boolean.parseBoolean(request.getParameter("useCreateDate"));
			boolean ignoreDeleted = Boolean.parseBoolean(request.getParameter("ignoreDeleted"));
			SortOrder sortOrder = StringUtils.isBlank(request.getParameter("sortOrder")) ? null : SortOrder.valueOf(request.getParameter("sortOrder"));
			Integer limit = StringUtils.isBlank(request.getParameter("limit")) ? null : Integer.valueOf(request.getParameter("limit"));
			%><%= renderStrings(storage.getDictionaryStorage().getDictionaryUids(cls, startDate, endDate, useCreateDate, ignoreDeleted, sortOrder, limit, ss)) %><%
		} else if ("getDbProperty".equals(method)) {
			String key = request.getParameter("key");
			%><%= storage.getDBPropertiesStorage().getDbProperty(key) %><%
		} else if ("putDbProperty".equals(method)) {
			String key = request.getParameter("key");
			String value = request.getParameter("value");
			String oldValue = request.getParameter("oldValue");
			storage.getDBPropertiesStorage().putDbProperty(key, value, oldValue);
		} else if ("getAllKeys".equals(method)) {
			%><%= render(storage.getDBPropertiesStorage().getAllKeys()) %><%
		} else {
			%>unknown method<%
		}
	} finally {
		ss.close();
	}
			
}
%>
<h2>Parameters</h2>
<table border="1">
	<tr>
		<th>name</th>
		<th>value</th>
	</tr>
<%
for (Enumeration<String> en = request.getParameterNames(); en.hasMoreElements(); ) {
	String paramName = en.nextElement();
	String paramValue = request.getParameter(paramName);
%>
	<tr>
		<td><%= paramName %></td>
		<td><%= paramValue %></td>
	</tr>
<%
}
%>
</table>
</body>
</html>
