<%/*****************************************************************
* Gridnine AB http://www.gridnine.com
* Project: White label
* Legal notice: (c) Gridnine AB. All rights reserved.
*****************************************************************/%><%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"


	import="com.gridnine.xtrip.common.model.assets.TemporalObject"
	import="com.gridnine.xtrip.common.xml.XUtil"
	import="com.gridnine.xtrip.common.search.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.util.Base64"
	import="com.gridnine.xtrip.server.gds.sirena2000.SSLSessionEntryInfoDirectProvider"

	import="java.io.*"
	import="java.util.*" 
	import="com.gridnine.xtrip.common.model.asset.AssetsStorage"
	import="com.gridnine.xtrip.server.db.storage.LogicalStorage"
	import="com.gridnine.xtrip.server.db.storage.common.LogicalSession"
%>

<%
	String action = request.getParameter("action");
	String data = request.getParameter("data");
	String clientid = request.getParameter("clientid");

	if(action==null){
		return;
	}

	if(action.equalsIgnoreCase("load")){
		%> <%=getSirenaSSLEntryInfo(clientid) %> <%
	}
	else if (action.equals("delete")){
		AssetsStorage as = AssetsStorage.get();
		SearchQuery q = new SearchQuery();
		q.getCriteria().getCriterions().add(SearchCriterion.like(TemporalObject.Property.tag.name(), "%sirena%"));
		for(TemporalObject t :AssetsStorage.get().search(TemporalObject.class, q).getData()){
			as.delete(t);
			%> TO deleted: <%= t.getTag() %> <br> <% 
		}
	}
	else if(action.equalsIgnoreCase("save")){
		if(data==null){
			%>missing parameter 'data'<%
		}

		byte[] dbytes = Base64.decode(data);
		TemporalObject tmp = new TemporalObject();
		tmp.setData(dbytes);
		tmp.setExpired(new Date(System.currentTimeMillis()
	            + (entryExpiredTimeout * 2)));
		tmp.setTag(SSLS_ENTRY_INFO.concat(clientid));
        AssetsStorage.get().save(tmp);
		%>ok<%
 	}
 	else if(action.equalsIgnoreCase("tryLock")){
         LogicalSession ms = null;
         try {
             boolean retval = true;

             ms = LogicalStorage.get().beginUnitOfWork();
             SearchQuery query = new SearchQuery();
             query
                 .getCriteria()
                 .getCriterions()
                 .add(
                     SearchCriterion.eq(TemporalObject.Property.tag.name(),
                         SSLS_ENTRY_INFO_LOCK));
             query.setLimit(1);
             SearchResult<TemporalObject> result =
                 AssetsStorage.get()
                     .search(TemporalObject.class, query);
             if (result.getData().size() > 0) {
                 retval = false;
             } else {
                 TemporalObject tmp = new TemporalObject();
                 tmp.setTag(SSLS_ENTRY_INFO_LOCK);
                 tmp.setData(new byte[1]);
                 tmp.setExpired(new Date(System.currentTimeMillis()
                     + entryExpiredTimeout));
                 AssetsStorage.get().save(tmp);
             }

             LogicalStorage.get().endUnitOfWork(ms, true);
 %><%=retval%><%
 	} catch (Exception ex) {

             if (ms != null) {
                 LogicalStorage.get().cancelUnitOfWork(ms);
             }

             throw ex;
         }

 	}
 	else if(action.equalsIgnoreCase("releaseLock")){
         SearchQuery query = new SearchQuery();
         query
             .getCriteria()
             .getCriterions()
             .add(
                 SearchCriterion.eq(TemporalObject.Property.tag.name(),
                     SSLS_ENTRY_INFO_LOCK));
         query.setLimit(1);
         SearchResult<TemporalObject> result =
             AssetsStorage.get()
                 .search(TemporalObject.class, query);

         if (result.getData().size() > 0) {
            AssetsStorage.get()
                 .delete(result.getData().get(0));
         }
 %>ok<%
    }


%>

<%!
    private final static String SSLS_ENTRY_INFO =
        "sirena.ssl-session-entry-info"; //$NON-NLS-1$

    private final static String SSLS_ENTRY_INFO_LOCK =
        "sirena.ssl-session-entry-info.lock"; //$NON-NLS-1$

    private static long entryExpiredTimeout = (1000 * 60 * 60); // 1 hour

%>

<%!static String getSirenaSSLEntryInfo(final String clientId) throws Exception {
        SearchQuery query = new SearchQuery();
        query
            .getCriteria()
            .getCriterions()
            .add(
                SearchCriterion.eq(TemporalObject.Property.tag.name(),
                    "sirena.ssl-session-entry-info".concat(clientId)));
        query.setLimit(1);

        SearchResult<TemporalObject> result =
        		AssetsStorage.get().search(TemporalObject.class, query);

		String response = null;
        if (result.getTotalCount() > 0) {
        	TemporalObject tmp =  result.getData().get(0);
   			byte[] data = tmp.getData();
   			response = Base64.encode(data);
        }

        return response;

    }

%>