#!/bin/bash
set -e
function snd {
    v="$(grep "$1" -l * | wc -l)"
    echo -n "$v;" >> ../sabrestat-result
    if [ "$v" -ne "0" ]
    then
        rm `grep "$1" -l *`
    fi
}

echo "Sabre Stats for IPCC $1 date $2"
if [ -f "sabrestat-result" ]
then
    echo "output file exists"
else
    echo "output file does not exist, writing header"
    echo "Date;Total;Not found;NO FLIGHT SCHEDULES FOR QUALIFIERS USED;NO FLIGHTS FOUND FOR ...;NO VALID FLIGHTS FOUND FOR ...;NO VALID COMBINATIONS FOUND;NO COMBINABLE FARES FOR CLASS USED;Unknown" >> sabrestat-result
fi
mkdir -p sabrestat-tmp
mkdir -p unknown
cd sabrestat-tmp
tar xzf /usr/local/midoffice/temp/server/gds-trace/SABRE/"$2".tar.gz --wildcards --no-anchored 'searchFlights*.xml'
rm `grep "PseudoCityCode=\"$1\"" -L *`
echo -n "$2;" >> ../sabrestat-result
echo -n "$(ls | wc -l);" >> ../sabrestat-result
rm `grep "PricedItinerary SequenceNumber=\"1\"" -l *`
echo -n "$(ls | wc -l);" >> ../sabrestat-result
snd "NO FLIGHT SCHEDULES FOR QUALIFIERS USED"
snd "NO FLIGHTS FOUND FOR"
snd "NO VALID FLIGHTS FOUND FOR"
snd "NO VALID COMBINATIONS FOUND"
snd "NO COMBINABLE FARES FOR CLASS USED"
echo "$(ls | wc -l)" >> ../sabrestat-result
mv * ../unknown
cd ..

