import java.util.stream.Collectors

import org.slf4j.Logger
import org.slf4j.LoggerFactory

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.booking.BaseProduct
import com.gridnine.xtrip.common.model.booking.BookingFile
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

// Script create for TUI to clear
// products shipments date for some clients

Logger logger = LoggerFactory.getLogger('groovy-script')

logger.info("Clear shipments date: started")

boolean except = true
String clientUid = ""

logger.info("Clear shipments date: except is " + except)
logger.info("Clear shipments date: clientUid is " + clientUid)

EntityReference<Organization> client = new EntityReference<>(clientUid, Organization.class, null)

SearchQuery query = new SearchQuery()

query.getCriteria().getCriterions().add(except ? SearchCriterion.ne(CommonProductIndex.Property.client.name(), client) : SearchCriterion.eq(CommonProductIndex.Property.client.name(), client))
query.getCriteria().getCriterions().add(SearchCriterion.ne(CommonProductIndex.Property.shipmentsDate.name(), null))

List<CommonProductIndex> indexes = EntityStorage.get().search(CommonProductIndex.class, query).getData()

logger.info("Clear shipments date: found indexes " + indexes.size())

Set<String> processed = new HashSet<>()

for(CommonProductIndex index : indexes) {
    
    if(!processed.contains(index.getSource().getUid())) {
        
        EntityContainer<BookingFile> bookingFileContainer = EntityStorage.get().resolve(index.getSource())
    
        if(bookingFileContainer != null) {
            
            BookingFile bookingFile = bookingFileContainer.getEntity()
            
            logger.info("Clear shipments date: processing booking file " + bookingFile + " (" + bookingFile.getUid() + ")")
            
            List<BaseProduct> products = bookingFile.getReservations().stream().flatMap({item -> item.getProducts().stream()}).collect(Collectors.toList())
            
            for(BaseProduct product : products) {
                
                logger.info("Clear shipments date: processing product" + ProductHandler.of(product).generateShortProductName(product) + " (" + product.getUid() + ")")
                
                product.setShipmentsDate(null)
                product.setShipmentsDateSubagent(null);
            }
            
            bookingFileContainer.getVersionInfo().setDataSource("clear-shipments-date-script")
            
            EntityStorage.get().save(bookingFileContainer, true)
        }
        
        processed.add(index.getSource().getUid())
    }
}

logger.info("Clear shipments date: finished")
