import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.model.system.PaymentType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

String code = "5555555";

SearchQuery query = new SearchQuery();

query.getCriteria().getCriterions().add(SearchCriterion.or(
        SearchCriterion.contains(OrganizationIndex.Property.types.name(),
        OrganizationType.AGENCY),
        SearchCriterion.contains(OrganizationIndex.Property.types.name(),
        OrganizationType.CORPORATE_CLIENT)));

List<OrganizationIndex> indexes = EntityStorage.get()
        .search(OrganizationIndex.class, query).getData();

for (OrganizationIndex index : indexes) {

    EntityContainer<Organization> organizationContainer =
            EntityStorage.get().resolve(index.getSource());

    if (organizationContainer != null) {

        boolean save = false;

        Organization organization = organizationContainer.getEntity();

        organization.getFopPaymentInfos().clear();

        for (PaymentType type : PaymentType.values()) {

            FopPaymentInfo fopPaymentInfo = new FopPaymentInfo();

            fopPaymentInfo.setPaymentType(type);
            fopPaymentInfo.setCreatePaymentDate(false);
            fopPaymentInfo.setCreatePaymentTransaction(false);

            organization.getFopPaymentInfos().add(fopPaymentInfo);
            
            save = true;
        }

        if (save) {

            organizationContainer.getVersionInfo().setDataSource(
                    "update_organization_fop_payment_infos_script");

            EntityStorage.get().save(organizationContainer, true);
        }
    }
}
