/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.bus.dicts.handlers;

import com.gridnine.xtrip.client.fx.bus.dicts.handlers.ControllerInterceptors.BusStationPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.bus.model.dict.BusStationPanel;
import com.gridnine.xtrip.client.fx.bus.model.dict.BusStationPanelController;
import com.gridnine.xtrip.client.fx.bus.model.dict.BusStationPanelVM;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.dict.bus.BusStationReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class BusStationHandler
extends BaseDictHandler<BusStationPanel, BusStation, BusStationPanelVM> {
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)BusStation.Property.country.name(), (String)Messages.Country, (Renderer)StandardRenderers.GENERIC));
    }

    protected void configureController(List<BiConsumer<BusStation, BusStationPanelVM>> toVM, List<BiConsumer<BusStationPanelVM, BusStation>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new BusStationPanelControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setCountry(model.getCountry());
            vm.getMain().setParent(model.getParent());
            vm.getMain().setRailwayStation(model.getRailwayStation());
            vm.getMain().setCity(model.getCity());
            vm.getBusAdditional().setActive(model.isActive());
            vm.getBusAdditional().setVisible(model.isVisible());
            DictHandlersHelper.codeVariantsToVM((Map)model.getCodeVariants(), (List)vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM((Map)model.getTranslations(), (List)vm.getTranslations().getContent());
            DictHandlersHelper.spellVariantsToVM((Set)model.getSpellVariants(), (List)vm.getSpellVariants().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCountry(vm.getMain().getCountry());
            model.setParent(vm.getMain().getParent());
            model.setRailwayStation(vm.getMain().getRailwayStation());
            model.setCity(vm.getMain().getCity());
            model.setActive(vm.getBusAdditional().isActive());
            model.setVisible(vm.getBusAdditional().isVisible());
            DictHandlersHelper.codeVariantsFromVM((List)vm.getCodeVariants().getContent(), (Map)model.getCodeVariants());
            DictHandlersHelper.translationsFromVM((List)vm.getTranslations().getContent(), (Map)model.getTranslations());
            DictHandlersHelper.spellVariantsFromVM((List)vm.getSpellVariants().getContent(), (Set)model.getSpellVariants());
        });
    }

    protected BusStationPanelVM createVM() {
        return new BusStationPanelVM();
    }

    protected ViewController<BusStationPanel, BusStationPanelVM> createController() {
        return new BusStationPanelController(false);
    }

    public Class<BusStation> getDictType() {
        return BusStation.class;
    }

    public DictionaryReference<BusStation> createReference(String code) {
        return new BusStationReference(code);
    }
}

