/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core;

import com.gridnine.xtrip.client.fx.core.MainPane;
import com.gridnine.xtrip.client.fx.core.TtitleServiceImpl;
import com.gridnine.xtrip.client.fx.core.activity.ActivitiesView;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManagerAppStopHook;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStopHook;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.startup.Startup;
import com.gridnine.xtrip.client.fx.core.tasks.NotificationPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.HeaderPane;
import com.gridnine.xtrip.client.fx.core.ui.WorkspacePane;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceHelper;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceModificationEvent;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabContentWrapper;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.JpfUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.Boot;
import org.java.plugin.registry.Extension;

public class Main
extends javafx.application.Application {
    private static Application app;
    private boolean closeInProgress;

    public static Application getApp() {
        return app;
    }

    public static void start(Application jpfApp, String[] args) {
        System.getProperties().putIfAbsent("prism.forceGPU", Boolean.TRUE.toString());
        if (Boolean.FALSE.toString().equals(System.getProperty("prism.forceGPU"))) {
            System.setProperty("prism.order", "sw,j2d");
        }
        System.setProperty("prism.vsync", Boolean.FALSE.toString());
        app = jpfApp;
        Main.launch(Main.class, (String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        FxRes.getTheme().getAppIcons().stream().map(url -> new Image(url.toExternalForm())).collect(Collectors.toCollection(() -> ((Stage)primaryStage).getIcons()));
        try {
            Field fieldBehavior = Tooltip.class.getDeclaredField("BEHAVIOR");
            fieldBehavior.setAccessible(true);
            Object objBehavior = fieldBehavior.get(null);
            Field fieldTimer = objBehavior.getClass().getDeclaredField("activationTimer");
            fieldTimer.setAccessible(true);
            Timeline objTimer = (Timeline)fieldTimer.get(objBehavior);
            objTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(new Duration(250.0), new KeyValue[0])});
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
        Startup.execute(app, primaryStage, () -> this.createMainScene(primaryStage));
    }

    public void stop() throws Exception {
        Boot.stopApplication((Application)app);
    }

    private void createMainScene(Stage stage) {
        NotificationPane notificationPane = new NotificationPane();
        HeaderPane headerPane = new HeaderPane();
        headerPane.setDisable(true);
        MainPane mainPane = new MainPane(notificationPane, headerPane);
        Scene scene = new Scene((Parent)mainPane);
        FxRes.addStylesheets(scene);
        stage.setAlwaysOnTop(false);
        stage.setResizable(true);
        stage.setMinWidth(800.0);
        stage.setMinHeight(600.0);
        stage.setScene(scene);
        stage.toFront();
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        stage.setWidth(bounds.getWidth() * 0.85);
        stage.setHeight(bounds.getHeight() * 0.85);
        stage.centerOnScreen();
        Dialog.setGlobalWindow((Node)mainPane);
        Environment.publish((Object)new Notifications(notificationPane));
        Environment.publish(WindowTitleService.class, (Object)new TtitleServiceImpl(stage));
        Notifications.get().submitTask(() -> this.init(headerPane, mainPane.getWorkspacePane()), Messages.Main_Initializing);
        FxUtil.submitToFxThread(() -> {
            UiSettings settings = new UiSettings("main", UiSettings.stagePersister(stage));
            settings.load();
            stage.setOnHidden(evt -> {
                settings.save();
                mainPane.getWorkspacePane().getNavigationPane().saveTreeState();
            });
        });
        stage.setOnCloseRequest(evt -> {
            evt.consume();
            if (this.closeInProgress) {
                return;
            }
            this.closeInProgress = true;
            AtomicBoolean shutdownInterrupted = new AtomicBoolean();
            AtomicInteger counter = new AtomicInteger();
            for (AppStopHook hook : ClientRegistry.get().allOf(AppStopHook.TYPE).values().stream().sorted(AppStopHook.COMPARATOR).collect(Collectors.toList())) {
                if (shutdownInterrupted.get()) break;
                counter.incrementAndGet();
                hook.shutdownRequested(shutdown -> {
                    if (shutdownInterrupted.get()) {
                        return;
                    }
                    if (!shutdown) {
                        this.closeInProgress = false;
                        shutdownInterrupted.set(true);
                        return;
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.closeInProgress = false;
                        FxUtil.submitToFxThread(() -> ((Stage)stage).close());
                    }
                });
            }
            if (shutdownInterrupted.get() || counter.get() != 0) {
                return;
            }
            this.closeInProgress = false;
            stage.close();
        });
    }

    private void init(final HeaderPane headerPane, WorkspacePane workspacePane) throws Exception {
        Environment.publish((Object)new ActivityManager(new ActivitiesView(){

            @Override
            public Scene getScene() {
                return headerPane.getScene();
            }

            @Override
            public ObservableList<TabPaneTab> getTabs() {
                return headerPane.getTabPane().getRegularTabs();
            }

            @Override
            public SingleSelectionModel<TabPaneTab> getSelectionModel() {
                return headerPane.getTabPane().getRegularTabsSelectionModel();
            }

            @Override
            public List<TabPaneTab> getSelectionHistory() {
                return headerPane.getTabPane().getRegularTabsHistory();
            }
        }));
        ClientRegistry.get().register((RegistryItem<?>)new ActivityManagerAppStopHook(ActivityManager.get()));
        ClientRegistry.get().allOf(AppStartHook.TYPE).values().stream().sorted(AppStartHook.COMPARATOR).forEach(AppStartHook::execute);
        ActivityManager.get().loadState();
        EventBus.get().publishSync(new WorkspaceModificationEvent(WorkspaceHelper.loadWorkspace()));
        headerPane.initMainTools();
        workspacePane.getNavigationPane().initFactoryTools();
        FxUtil.submitToFxThread(() -> {
            String token = ClientSettings.get().getSelectedActivity();
            if (token != null) {
                ActivityManager.get().find(token, true, null);
            }
            try {
                List extensions = JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.client.fx.core", (String)"Home");
                if (!extensions.isEmpty()) {
                    Node homeNode = (Node)JpfUtil.getClass((Extension)((Extension)extensions.get(extensions.size() - 1))).newInstance();
                    headerPane.getHomeTab().setContent((Node)new TabContentWrapper(homeNode));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
            if (DevTools.init(headerPane.getScene())) {
                Notifications.get().showFlashNotification("Dev Tools installed.\nUse Alt - Right Click to view node details.", null);
            }
            headerPane.setDisable(false);
        });
    }
}

