/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogContainer;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogPane;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.tasks.NotificationPane;
import com.gridnine.xtrip.client.fx.core.ui.HeaderPane;
import com.gridnine.xtrip.client.fx.core.ui.LogoPane;
import com.gridnine.xtrip.client.fx.core.ui.WorkspacePane;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.util.Duration;

class MainPane
extends BorderPane
implements DialogContainer {
    private static final Duration ANIMATION_DURATION = Duration.millis((double)350.0);
    private static final Interpolator ANIMATION_INTERPOLATOR = new Interpolator(){

        protected double curve(double t) {
            return Math.sqrt(t);
        }
    };
    private LogoPane logoPane;
    private final HeaderPane headerPane;
    private WorkspacePane workspacePane;
    private final NotificationPane notificationPane;
    private DialogPane dialogPane;
    private boolean hide = true;
    private boolean animating = false;

    MainPane(NotificationPane np, HeaderPane hp) {
        this.notificationPane = np;
        this.headerPane = hp;
        this.getStyleClass().add((Object)"main-pane");
        this.createGUI();
        this.createBindings();
        this.createListeners();
        this.headerPane.getTabPane().selectSpecialFirst();
    }

    private void createGUI() {
        this.setPrefSize(1000.0, 600.0);
        Pane mainPane = this.createMainPane();
        this.setCenter((Node)mainPane);
    }

    private Pane createMainPane() {
        this.logoPane = new LogoPane();
        this.workspacePane = new WorkspacePane();
        this.dialogPane = new DialogPane();
        this.headerPane.getTabPane().setContentPane((Pane)this.workspacePane.getContentPane());
        GridPane mainPaneContainerPane = new GridPane();
        mainPaneContainerPane.getStyleClass().add((Object)"xtrip-main-pane-container-pane");
        UiUtil.gridPosition(mainPaneContainerPane, (Node)this.logoPane).col(0).row(0).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
        UiUtil.gridPosition(mainPaneContainerPane, (Node)this.headerPane).col(1).row(0).vGrow(Priority.NEVER).place();
        UiUtil.gridPosition(mainPaneContainerPane, (Node)this.workspacePane).col(0).row(1).colSpan(2).place();
        UiUtil.gridPosition(mainPaneContainerPane, (Node)this.dialogPane).col(0).row(0).colSpan(2).rowSpan(2).place();
        HPos notificationsPanePos = "true".equalsIgnoreCase(System.getProperty("client.fx.MainPane.notificationsOnLeft")) ? HPos.LEFT : HPos.RIGHT;
        UiUtil.gridPosition(mainPaneContainerPane, (Node)this.notificationPane).col(0).row(0).colSpan(2).rowSpan(2).dontFill().hAlignment(notificationsPanePos).vAlignment(VPos.BOTTOM).place();
        return mainPaneContainerPane;
    }

    private void createBindings() {
        this.logoPane.animationTransitionProperty().bind((ObservableValue)this.workspacePane.animationTransitionProperty());
    }

    private void createListeners() {
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (this.getDialogPane().isVisible()) {
                if (!Dialog.isDialogElement((Node)event.getTarget())) {
                    event.consume();
                }
                return;
            }
            KeyBindings kb = KeyBindings.get();
            if (kb.getKeyCombination(StandardKeyBindingActions.NAV_PANE_TOGGLE).match(event)) {
                this.toggleNavigationPane();
                this.workspacePane.requestLayout();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.TAB_PREV).match(event)) {
                this.headerPane.getTabPane().selectRegularPrevious();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.TAB_NEXT).match(event)) {
                this.headerPane.getTabPane().selectRegularNext();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.TAB_FIRST).match(event)) {
                this.headerPane.getTabPane().selectRegularFirst();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.TAB_LAST).match(event)) {
                this.headerPane.getTabPane().selectRegularLast();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.TAB_CLOSE).match(event)) {
                TabPaneTab tab = (TabPaneTab)this.headerPane.getTabPane().getRegularTabsSelectionModel().getSelectedItem();
                if (tab != null) {
                    tab.close();
                }
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.NAV_PANE_EXPAND_TREE).match(event)) {
                UiUtil.expand(this.workspacePane.getNavigationPane().getTree(), 2);
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.NAV_PANE_COLLAPSE_TREE).match(event)) {
                UiUtil.collapse(this.workspacePane.getNavigationPane().getTree(), 1);
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.MAIN_MENU_SHOW).match(event)) {
                this.headerPane.toggleMainMenu();
                event.consume();
            } else if (kb.getKeyCombination(StandardKeyBindingActions.FACTORIES_PANE).match(event)) {
                this.workspacePane.getNavigationPane().showFactoryTools();
                event.consume();
            } else {
                this.headerPane.handleShortcut((KeyEvent)event);
            }
        });
        this.headerPane.getTabPane().addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            if (evt.getClickCount() == 2) {
                this.toggleNavigationPane();
                evt.consume();
            }
        });
        this.logoPane.getButton().setOnMouseClicked(event -> {
            this.toggleNavigationPane();
            event.consume();
        });
    }

    private void toggleNavigationPane() {
        if (this.animating) {
            return;
        }
        this.animating = true;
        Timeline animation = this.hide ? this.createHideAnimation() : this.createShowAnimation();
        animation.play();
        this.hide = !this.hide;
    }

    private Timeline createHideAnimation() {
        Timeline animation = new Timeline();
        KeyValue keyValue = new KeyValue((WritableValue)this.workspacePane.animationTransitionProperty(), (Object)-1.0, ANIMATION_INTERPOLATOR);
        KeyFrame keyFrame = new KeyFrame(ANIMATION_DURATION, new KeyValue[]{keyValue});
        animation.getKeyFrames().clear();
        animation.getKeyFrames().add((Object)keyFrame);
        animation.setOnFinished(e -> {
            this.workspacePane.animationTransitionProperty().set(-1.0);
            this.animating = false;
        });
        return animation;
    }

    private Timeline createShowAnimation() {
        Timeline animation = new Timeline();
        KeyValue keyValue = new KeyValue((WritableValue)this.workspacePane.animationTransitionProperty(), (Object)0.0, ANIMATION_INTERPOLATOR);
        KeyFrame keyFrame = new KeyFrame(ANIMATION_DURATION, new KeyValue[]{keyValue});
        animation.getKeyFrames().clear();
        animation.getKeyFrames().add((Object)keyFrame);
        animation.setOnFinished(e -> {
            this.workspacePane.animationTransitionProperty().set(0.0);
            this.animating = false;
        });
        return animation;
    }

    @Override
    public DialogPane getDialogPane() {
        return this.dialogPane;
    }

    public WorkspacePane getWorkspacePane() {
        return this.workspacePane;
    }
}

