/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.acl;

import com.gridnine.xtrip.client.fx.core.acl.AclService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class AppliedAclData {
    private final Map<String, Map<String, Boolean>> data;

    public static void loadForMetaBasedUI(Consumer<AppliedAclData> callback, String ... nodeClassNames) throws Exception {
        UiMetaRegistry registry = UiMetaRegistry.get();
        HashSet<String> roots = new HashSet<String>();
        for (String nodeId : nodeClassNames) {
            UiTilesSpace space = (UiTilesSpace)registry.getSpaces().get(nodeId);
            if (space != null) {
                if (space.getAcl() == null) continue;
                roots.add(space.getAcl().getId());
                continue;
            }
            BaseUiContainer ctr = (BaseUiContainer)registry.getContainers().get(nodeId);
            if (ctr == null || ctr.getAcl() == null) continue;
            roots.add(ctr.getAcl().getId());
        }
        AppliedAclData data = roots.isEmpty() ? new AppliedAclData(Collections.emptyMap()) : new AppliedAclData(AclService.get().applyAcl(roots));
        FxUtil.submitToFxThread(() -> callback.accept(data));
    }

    public static AppliedAclData load(String ... roots) throws Exception {
        return AppliedAclData.load(new HashSet<String>(Arrays.asList(roots)));
    }

    public static AppliedAclData load(Set<String> roots) throws Exception {
        if (roots.isEmpty()) {
            return new AppliedAclData(Collections.emptyMap());
        }
        Map<String, Map<String, Boolean>> data = AclService.get().applyAcl(roots);
        return new AppliedAclData(data);
    }

    private AppliedAclData(Map<String, Map<String, Boolean>> loaded) {
        this.data = loaded;
    }

    public boolean canView(String resourceId) {
        if (resourceId == null) {
            return true;
        }
        Map<String, Boolean> map = this.data.get(resourceId);
        if (map == null) {
            return true;
        }
        Boolean result = map.get(StandardRestrictionResourceOperations.VIEW.getId());
        if (result == null) {
            result = map.get(StandardRestrictionResourceOperations.ALL.getId());
        }
        return result;
    }

    public boolean canEdit(String resourceId) {
        if (resourceId == null) {
            return true;
        }
        Map<String, Boolean> map = this.data.get(resourceId);
        if (map == null) {
            return true;
        }
        Boolean result = map.get(StandardRestrictionResourceOperations.EDIT.getId());
        if (result == null) {
            result = map.get(StandardRestrictionResourceOperations.ALL.getId());
        }
        return result;
    }
}

