/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.activity;

import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import javafx.scene.Node;

public abstract class ActivityHandler<V extends Node, P>
implements RegistryItem<ActivityHandler<?, ?>> {
    public static final RegistryItemType<ActivityHandler<?, ?>> TYPE = new RegistryItemType("ACTIVITY-HANDLER");

    public static ActivityHandler<?, ?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    @Override
    public final RegistryItemType<ActivityHandler<?, ?>> getType() {
        return TYPE;
    }

    final V getOrCreateView(ActivityState<V, P> state) throws Exception {
        if (state.getView() != null) {
            return state.getView();
        }
        V view = this.createView(state);
        view.getProperties().put((Object)ObservableMutex.class.getName(), (Object)state.getMutex());
        state.setView(view);
        state.scheduleSave(true);
        return state.getView();
    }

    protected final V getView(ActivityState<V, P> state) {
        return state.getView();
    }

    protected abstract V createView(ActivityState<V, P> var1) throws Exception;

    protected abstract Serializer<P> getSerializer();

    protected boolean hasChanges(ActivityState<V, P> state) {
        return false;
    }

    protected void onClosed(ActivityState<V, P> state) {
    }

    protected boolean isHighlighted(ActivityState<V, P> state) {
        return MiscUtil.equals((Object)state.getLockOwner(), (Object)ServiceInvocationContext.get().getUser());
    }

    protected boolean validate(ActivityState<V, P> state) {
        return true;
    }

    protected abstract void saveChanges(ActivityState<V, P> var1) throws Exception;

    final boolean isSaveRequired(ActivityState<V, P> state) {
        V view = state.getView();
        if (view == null) {
            return false;
        }
        view.requestFocus();
        return this.hasChanges(state);
    }

    protected void handleClosing(ActivityState<V, P> state, Runnable callback) {
        callback.run();
    }

    protected final void tryLock(ActivityState<V, P> state) throws Exception {
        if (state.isLocked()) {
            return;
        }
        if (!state.isStateful()) {
            throw new IllegalStateException("non-stateful activity can't be locked");
        }
        ActivityItem asset = state.getOrCreateAsset();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ActivityItem.Property.lockToken.name(), (Object)asset.getActivityToken()));
        query.getPreferredProperties().add(ActivityItem.Property.owner.name());
        List lockedItems = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(sic, ActivityItem.class, query).getData();
        if (!lockedItems.isEmpty()) {
            String lockOwner = ((ActivityItem)lockedItems.get(0)).getOwner();
            if (asset.getOwner().equals(lockOwner)) {
                asset.setLocked(true);
                state.scheduleSave(false);
            } else {
                state.setLockOwner(lockOwner);
            }
        } else {
            asset.setLocked(true);
            state.scheduleSave(false);
        }
    }

    protected final void unLock(ActivityState<V, P> state, boolean force) {
        if (!state.isLocked()) {
            return;
        }
        this.doUnlock(state);
        state.scheduleSave(force);
    }

    protected void doUnlock(ActivityState<V, P> state) {
        state.getOrCreateAsset().setLocked(false);
        state.setLockOwner(null);
    }
}

