/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.assets;

import com.gridnine.xtrip.client.fx.core.assets.AssetListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.model.BaseAsset;

public interface AssetHandler<A extends BaseAsset>
extends RegistryItem<AssetHandler<?>> {
    public static final RegistryItemType<AssetHandler<?>> TYPE = new RegistryItemType("ASSET-HANDLER");

    public static AssetHandler<?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static <A extends BaseAsset> AssetHandler<A> forAssetClass(Class<A> assetClass) {
        String className = assetClass.getName();
        for (AssetHandler<?> handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getAssetType().getName().equals(className)) continue;
            return handler;
        }
        return null;
    }

    @Override
    default public RegistryItemType<AssetHandler<?>> getType() {
        return TYPE;
    }

    @Override
    default public String getId() {
        return this.getAssetType().getName();
    }

    default public String getName() {
        return this.getAssetType().getSimpleName();
    }

    default public String format(A asset) {
        return asset.toString();
    }

    public Class<A> getAssetType();

    public AssetListParameters getStandardListParameters();

    public boolean isCollection(String var1);

    public Object getValue(A var1, String var2);

    public ViewController<?, A> createEditorController(ObservableMutex var1);
}

