/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.devtools;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.Collections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public final class DevTools {
    public static boolean init(Scene scene) {
        if (!"true".equalsIgnoreCase(System.getProperty("client.fx.devtools.enabled"))) {
            return false;
        }
        KeyCodeCombination copyCC = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});
        scene.addEventFilter(MouseEvent.MOUSE_CLICKED, evt -> {
            if (evt.isConsumed() || !evt.isAltDown() || evt.getButton() != MouseButton.SECONDARY) {
                return;
            }
            Node node = DevTools.pickNode((Node)scene.getRoot(), evt.getSceneX(), evt.getSceneY());
            if (node == null) {
                return;
            }
            evt.consume();
            boolean higlighted = node.getStyleClass().contains((Object)"dev-tools-highligted");
            Styles.manageStyle((Styleable)node, "dev-tools-highligted", !higlighted);
            if (higlighted) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            String prefix = "";
            for (Node nd = node; nd != null; nd = nd.getParent()) {
                buf.append(prefix).append(nd);
                if (prefix.isEmpty()) {
                    prefix = "\n";
                }
                prefix = prefix + '\t';
            }
            Tooltip tt = new Tooltip(buf.toString() + "\n\nUse Ctrl-C to put this info into clipboard.");
            tt.setAutoHide(true);
            tt.addEventHandler(KeyEvent.KEY_PRESSED, evt2 -> {
                if (copyCC.match(evt2)) {
                    Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, buf.toString()));
                    tt.hide();
                }
            });
            tt.show(node, evt.getScreenX(), evt.getScreenY());
        });
        return true;
    }

    private static Node pickNode(Node node, double sceneX, double sceneY) {
        Point2D p = node.sceneToLocal(sceneX, sceneY, true);
        if (!node.contains(p)) {
            return null;
        }
        if (node instanceof Parent) {
            Node bestMatchingChild = null;
            ObservableList children = ((Parent)node).getChildrenUnmodifiable();
            for (int i = children.size() - 1; i >= 0; --i) {
                Node child = (Node)children.get(i);
                p = child.sceneToLocal(sceneX, sceneY, true);
                if (!child.isVisible() || child.isMouseTransparent() || !child.contains(p)) continue;
                bestMatchingChild = child;
                break;
            }
            if (bestMatchingChild != null) {
                return DevTools.pickNode(bestMatchingChild, sceneX, sceneY);
            }
        }
        return node;
    }

    public static String getStructuredInfo(Object node) {
        return FxUtil.toString(Collections.singletonList(node), item -> {
            if (item instanceof DevTool) {
                return ((DevTool)item).asDevToolItem().getSubItems();
            }
            return Collections.emptyList();
        }, item -> {
            if (item instanceof DevTool) {
                return ((DevTool)item).asDevToolItem().getInfo();
            }
            if (item == null) {
                return "null";
            }
            String result = item.getClass().getSimpleName();
            if (item instanceof HasViewState) {
                result = result + DevTools.getViewStateInfo(((HasViewState)item).getViewState());
            }
            return result;
        });
    }

    public static String getViewStateInfo(ViewState state) {
        if (!state.isImmutable()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (state.isReadonly()) {
            buf.append(" [readonly]");
        }
        if (state.isNotEditable()) {
            buf.append(" [not editable]");
        }
        if (state.isAclNotEditable()) {
            buf.append(" [forbidden]");
        }
        return buf.toString();
    }

    private DevTools() {
    }
}

