/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dialogs;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.ButtonData;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogContainer;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogPane;
import com.gridnine.xtrip.client.fx.core.dialogs.ValidationMessageData;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class Dialog {
    private static Node globalWindow;
    private final List<ButtonData> buttons = new ArrayList<ButtonData>();
    private DialogPane dialogPane;
    private String title;
    private Supplier<QuickHelp> help;
    private String message;
    private String supMessage;
    private Node body;
    private boolean wrapWithScrollPane;
    private boolean autoClose = true;
    private Runnable onCloseRequest;
    private boolean expand = false;
    private boolean ignoreEnterKeyAndDoubleClick = false;
    private boolean ignoreEscapeKey = false;
    private Supplier<List<MenuItem>> adminToolsSupplier;
    final ObservableList<ValidationMessageData> validationMessages = FXCollections.observableArrayList();

    public static Node getGlobalWindow() {
        return globalWindow;
    }

    public static void setGlobalWindow(Node node) {
        globalWindow = node;
    }

    public static void info(String text) {
        Dialog.info(globalWindow, text);
    }

    public static void message(String title, String text) {
        Dialog.message(globalWindow, title, text);
    }

    public static void info(Node parent, String text) {
        FxUtil.runInFxThread(() -> {
            Dialog dialog = new Dialog().setMessage(text).addButton(DialogButtonStyle.ACCEPT_REGULAR);
            dialog.show(parent);
        });
    }

    public static void message(Node parent, String title, String text) {
        FxUtil.runInFxThread(() -> {
            CustomTextArea body = new CustomTextArea();
            body.setEditable(false);
            body.setText(text);
            Dialog dialog = new Dialog();
            dialog.setTitle(title).setBody((Node)body).setExpandToParent().setAutoClose(false).setOnCloseRequest(dialog::close).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close, dialog::close).addButton(DialogButtonStyle.AUXILARY, Messages.General_Copy, () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, body.getText())));
            dialog.show(parent);
        });
    }

    public static void info(Node parent, String text, String supText) {
        FxUtil.runInFxThread(() -> {
            Dialog dialog = new Dialog().setMessage(text).setSupplmentalMessage(supText).addButton(DialogButtonStyle.ACCEPT_REGULAR);
            dialog.show(parent);
        });
    }

    public static void confirm(String text, Runnable callback) {
        Dialog.confirm(globalWindow, text, null, null, callback, null);
    }

    public static void confirm(Node owner, String text, Runnable callback) {
        Dialog.confirm(owner, text, null, null, callback, null);
    }

    public static void confirm(Node owner, String text, String supplementalText, String acceptCaption, Runnable acceptCallback, Runnable declineCallback) {
        new Dialog().setTitle(Messages.General_Accepting_required).setMessage(text).setSupplmentalMessage(supplementalText).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel, declineCallback).addButton(DialogButtonStyle.ACCEPT_REGULAR, acceptCaption != null ? acceptCaption : Messages.General_Accept, acceptCallback).setOnCloseRequest(declineCallback).show(owner);
    }

    public static void error(Throwable error) {
        Dialog.error(globalWindow, error);
    }

    public static void error(Node owner, Throwable error) {
        if (error == null) {
            return;
        }
        CustomTextArea detailsArea = new CustomTextArea();
        detailsArea.setEditable(false);
        detailsArea.setText(ErrorHandler.getDetails(error));
        new Dialog().setTitle(Messages.General_Error_message).setBody((Node)detailsArea).addButton(DialogButtonStyle.AUXILARY, Messages.General_Copy_full_report, () -> Dialog.fullReportToClipboard(error)).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close).show(owner);
    }

    public static boolean isDialogElement(Node node) {
        DialogPane dialogPane = Dialog.findDialogParent(node);
        return dialogPane != null;
    }

    public static List<Node> getOpened(Node owner) {
        DialogPane dialogPane = Dialog.findDialogParent(owner);
        if (dialogPane == null) {
            return Collections.emptyList();
        }
        return dialogPane.getOpened().stream().filter(dlg -> dlg.body != null).map(dlg -> dlg.body).collect(Collectors.toList());
    }

    private static void fullReportToClipboard(Throwable error) {
        StringBuilder buf = new StringBuilder();
        String ls = "\n";
        buf.append(new Date());
        buf.append(ls).append("-------------------------------------------------------------------------------").append(ls).append(ErrorHandler.getDetails(error));
        buf.append(ls).append("------------------------------ SYSTEM PROPERTIES ------------------------------").append(ls);
        Properties props = System.getProperties();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            buf.append(name).append('=').append(props.getProperty(name)).append(ls);
        }
        buf.append(ls).append("---------------------------- ENVIRONMENT VARIABLES ----------------------------").append(ls);
        for (Map.Entry entry : System.getenv().entrySet()) {
            buf.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append(ls);
        }
        buf.append(ls).append("-------------------------------- RUNTIME DATA ---------------------------------").append(ls);
        Runtime rt = Runtime.getRuntime();
        buf.append("Processors: ").append(rt.availableProcessors()).append(ls);
        buf.append("Free memory: ").append(rt.freeMemory()).append(ls);
        buf.append("Max memory: ").append(rt.maxMemory()).append(ls);
        buf.append("Total memory: ").append(rt.totalMemory()).append(ls);
        buf.append("Active threads: ").append(Thread.activeCount()).append(ls);
        Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, buf.toString()));
    }

    private static DialogPane findDialogParent(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof DialogPane) {
            return (DialogPane)node;
        }
        return Dialog.findDialogParent((Node)node.getParent());
    }

    private static DialogContainer findDialogContainer(Node parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof DialogContainer) {
            return (DialogContainer)parent;
        }
        return Dialog.findDialogContainer((Node)parent.getParent());
    }

    public void showGlobal() {
        this.show(globalWindow);
    }

    public void show(Node parent) {
        if (this.dialogPane != null) {
            return;
        }
        DialogContainer dialogContainer = Dialog.findDialogContainer(parent);
        if (dialogContainer == null) {
            return;
        }
        this.dialogPane = dialogContainer.getDialogPane();
        this.dialogPane.show(this, this.buildRootPane());
    }

    public void close() {
        if (this.dialogPane == null) {
            return;
        }
        this.dialogPane.hide(this);
        this.dialogPane = null;
    }

    public Dialog setTitle(String value) {
        this.title = value;
        return this;
    }

    public Dialog setHelp(Supplier<QuickHelp> value) {
        this.help = value;
        return this;
    }

    public Dialog setBody(Node value) {
        this.body = value;
        this.wrapWithScrollPane = true;
        return this;
    }

    public Dialog setBody(Node value, boolean doNotWrapWithScrollPane) {
        this.body = value;
        this.wrapWithScrollPane = !doNotWrapWithScrollPane;
        return this;
    }

    public Dialog setMessage(String value) {
        this.message = value;
        return this;
    }

    public Dialog setSupplmentalMessage(String value) {
        this.supMessage = value;
        return this;
    }

    public Dialog addButton(DialogButtonStyle style) {
        return this.addButton(style, null, (Runnable)null, null);
    }

    public Dialog addButton(DialogButtonStyle style, String text) {
        return this.addButton(style, text, (Runnable)null, null);
    }

    public Dialog addButton(DialogButtonStyle style, Runnable handler) {
        return this.addButton(style, null, handler, null);
    }

    public Dialog addButton(DialogButtonStyle style, String text, Runnable handler) {
        return this.addButton(style, text, handler, null);
    }

    public Dialog addButton(DialogButtonStyle style, Runnable handler, BooleanExpression availability) {
        return this.addButton(style, null, handler, availability);
    }

    public Dialog addButton(DialogButtonStyle style, String text, Runnable handler, BooleanExpression availability) {
        return this.addButton(style, text, (Region src) -> {
            if (handler != null) {
                handler.run();
            }
        }, availability);
    }

    public Dialog addButton(DialogButtonStyle style, String text, Consumer<Region> handler, BooleanExpression availability) {
        ButtonData data = new ButtonData();
        data.style = style;
        data.text = text;
        data.handler = () -> {
            if (this.autoClose) {
                this.close();
            }
            if (handler != null) {
                FxUtil.submitToFxThread(() -> handler.accept((Region)data.button));
            }
        };
        data.availability = availability;
        this.buttons.add(data);
        return this;
    }

    public Dialog setAutoClose(boolean value) {
        this.autoClose = value;
        return this;
    }

    public Dialog setOnCloseRequest(Runnable value) {
        this.onCloseRequest = value;
        return this;
    }

    @Deprecated
    public Dialog setExpandToParent() {
        this.expand = true;
        return this;
    }

    public Dialog setExpandToParent(boolean value) {
        this.expand = value;
        return this;
    }

    public Dialog setIgnoreEnterKeyAndDoubleClick(boolean value) {
        this.ignoreEnterKeyAndDoubleClick = value;
        return this;
    }

    public Dialog setIgnoreEscapeKey(boolean value) {
        this.ignoreEscapeKey = value;
        return this;
    }

    public Dialog setAdminToolsSupplier(Supplier<List<MenuItem>> value) {
        this.adminToolsSupplier = value;
        return this;
    }

    public void setValidationMessages(boolean autoHide, List<Message> messages) {
        if (messages.isEmpty()) {
            this.validationMessages.clear();
            return;
        }
        this.validationMessages.setAll((Collection)messages.stream().map(msg -> new ValidationMessageData(autoHide, (Message)msg)).collect(Collectors.toList()));
    }

    public void setValidationMessages(boolean autoHide, Message ... messages) {
        if (messages == null || messages.length == 0) {
            this.validationMessages.clear();
            return;
        }
        this.validationMessages.setAll((Collection)Arrays.stream(messages).map(msg -> new ValidationMessageData(autoHide, (Message)msg)).collect(Collectors.toList()));
    }

    public void addValidationMessages(boolean autoHide, List<Message> messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.validationMessages.addAll((Collection)messages.stream().map(msg -> new ValidationMessageData(autoHide, (Message)msg)).collect(Collectors.toList()));
    }

    public void addValidationMessages(boolean autoHide, Message ... messages) {
        if (messages == null || messages.length == 0) {
            return;
        }
        this.validationMessages.addAll((Collection)Arrays.stream(messages).map(msg -> new ValidationMessageData(autoHide, (Message)msg)).collect(Collectors.toList()));
    }

    private Pane buildRootPane() {
        ButtonData acceptButton;
        if (TextUtil.isBlank((String)this.message) && this.body == null) {
            throw Xeption.forDeveloper((String)"illegal dialog configuration - neither message nor body provided", (Object[])new Object[0]);
        }
        BorderPane result = new BorderPane();
        result.getStyleClass().add((Object)"xtrip-dialog-window");
        HBox titlePane = new HBox();
        titlePane.getStyleClass().add((Object)"title-pane");
        IconNode icon = new IconNode(StandardIconShapes.ROOT_VIEW_12x12, null, StandardIconIntentions.CLOSE_BUTTON_ACTION, null);
        icon.hoverProperty().addListener((s, o, n) -> {
            DialogContainer dlgCtr;
            if (icon.getProperties().containsKey((Object)"animation")) {
                ((Animation)icon.getProperties().remove((Object)"animation")).stop();
            }
            if ((dlgCtr = Dialog.findDialogContainer((Node)result)) != null) {
                if (n.booleanValue()) {
                    UiUtil.traverse(this.body, node -> {
                        if (node instanceof ComboBoxBase) {
                            ((ComboBoxBase)node).hide();
                        }
                    });
                }
                FadeTransition tr = new FadeTransition();
                tr.setNode((Node)dlgCtr.getDialogPane());
                tr.setToValue(n != false ? 0.0 : 1.0);
                tr.play();
                icon.getProperties().put((Object)"animation", (Object)tr);
            }
        });
        icon.setCursor(Cursor.OPEN_HAND);
        titlePane.getChildren().add((Object)icon);
        Label label = new Label(TextUtil.isBlank((String)this.title) ? Messages.Dialog_title : this.title);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        titlePane.getChildren().add((Object)label);
        if (this.help != null) {
            label.setGraphic((Node)Buttons.quickHelpButton(this.help));
            label.getStyleClass().add((Object)"hasTooltip");
        }
        Button closeButton = new Button();
        closeButton.getStyleClass().add((Object)"close-button");
        closeButton.setGraphic((Node)new IconNode(StandardIconShapes.CANCEL, (Styleable)closeButton, StandardIconIntentions.CLOSE_BUTTON_ACTION, (Styleable)closeButton));
        closeButton.setOnAction(e -> {
            if (this.autoClose) {
                this.close();
            }
            if (this.onCloseRequest != null) {
                FxUtil.submitToFxThread(this.onCloseRequest::run);
            }
        });
        titlePane.getChildren().add((Object)closeButton);
        titlePane.setOnMouseClicked(evt -> {
            if (evt.isAltDown() && evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                CustomContextMenu cm = new CustomContextMenu();
                cm.getItems().addAll(this.collectAdminTools());
                cm.show((Node)titlePane, evt.getScreenX(), evt.getScreenY());
                evt.consume();
                return;
            }
        });
        result.setTop((Node)titlePane);
        BorderPane contentPane = new BorderPane();
        contentPane.getStyleClass().add((Object)"dialog-content-pane");
        if (!TextUtil.isBlank((String)this.message)) {
            VBox messagePane = new VBox();
            Styles.addStyle((Styleable)messagePane, "message-pane");
            Label label2 = new Label(this.message);
            label2.setWrapText(true);
            Styles.addStyle((Styleable)label2, "main-message");
            messagePane.getChildren().add((Object)label2);
            if (!TextUtil.isBlank((String)this.supMessage)) {
                Label supLabel = new Label(this.supMessage);
                supLabel.setWrapText(true);
                Styles.addStyle((Styleable)supLabel, "supplemental-message");
                messagePane.getChildren().add((Object)supLabel);
            }
            contentPane.setTop((Node)messagePane);
        }
        if (this.body != null) {
            Node bodyWrapper;
            if (this.body.getStyleClass().contains((Object)"simple-widget")) {
                bodyWrapper = new StackPane(new Node[]{this.body});
                bodyWrapper.getStyleClass().add((Object)"adopts-widget");
            } else {
                bodyWrapper = this.body;
            }
            if (this.expand && this.wrapWithScrollPane && !(this.body instanceof ScrollPane)) {
                ScrollPane sp = new ScrollPane(bodyWrapper);
                sp.getStyleClass().add((Object)"edge-to-edge");
                sp.setFitToWidth(true);
                sp.setFitToHeight(true);
                sp.prefViewportHeightProperty().addListener((obj, o, n) -> {
                    sp.setPrefHeight(n.doubleValue());
                    sp.setMaxHeight(n.doubleValue());
                    sp.setMinHeight(n.doubleValue());
                });
                contentPane.setCenter((Node)sp);
            } else {
                contentPane.setCenter(bodyWrapper);
            }
        }
        this.validationMessages.addListener(change -> this.handleValidationMessages(contentPane));
        result.setCenter((Node)contentPane);
        if (!this.buttons.isEmpty()) {
            ValueHolder acceptData = new ValueHolder();
            ArrayList leftButtons = new ArrayList();
            ArrayList rightButtons = new ArrayList();
            this.buttons.stream().sorted((data1, data2) -> data2.style.ordinal() - data1.style.ordinal()).forEach(data -> {
                Button button;
                data.button = button = new Button(TextUtil.isBlank((String)data.text) ? data.style.getDefaultCaption() : data.text);
                data.style.applyStyle(button);
                button.setOnAction(evt -> data.handler.run());
                if (data.availability != null) {
                    button.disableProperty().bind((ObservableValue)data.availability.not());
                }
                if (data.style == DialogButtonStyle.DECLINE) {
                    leftButtons.add(button);
                } else {
                    rightButtons.add(button);
                    if (acceptData.get() == null && (data.style == DialogButtonStyle.ACCEPT_REGULAR || data.style == DialogButtonStyle.ACCEPT_CONTINUE)) {
                        acceptData.set(data);
                    }
                }
            });
            HBox leftBox = new HBox();
            leftBox.getChildren().addAll(leftButtons);
            leftBox.getStyleClass().add((Object)"left");
            HBox rightBox = new HBox();
            rightBox.getChildren().addAll(rightButtons);
            rightBox.getStyleClass().add((Object)"right");
            GridPane.setHgrow((Node)rightBox, (Priority)Priority.ALWAYS);
            GridPane buttonsPane = new GridPane();
            buttonsPane.getStyleClass().add((Object)"buttons-pane");
            buttonsPane.addRow(0, new Node[]{leftBox, rightBox});
            result.setBottom((Node)buttonsPane);
            acceptButton = (ButtonData)acceptData.get();
        } else {
            acceptButton = null;
        }
        result.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() > 1) {
                if (!this.acceptsDoubleClick((Node)event.getTarget())) {
                    return;
                }
                if (!this.ignoreEnterKeyAndDoubleClick && acceptButton != null && (acceptButton.availability == null || acceptButton.availability.get())) {
                    acceptButton.handler.run();
                    event.consume();
                }
            }
        });
        result.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                if (this.ignoreEscapeKey) {
                    return;
                }
                if (this.autoClose) {
                    this.close();
                }
                if (this.onCloseRequest != null) {
                    FxUtil.submitToFxThread(this.onCloseRequest::run);
                }
                event.consume();
                return;
            }
            if (event.getCode() == KeyCode.ENTER) {
                if (this.ignoreEnterKeyAndDoubleClick) {
                    return;
                }
                if (!(event.getTarget() instanceof Control) && acceptButton != null && (acceptButton.availability == null || acceptButton.availability.get())) {
                    acceptButton.handler.run();
                    event.consume();
                }
            }
        });
        return result;
    }

    private void handleValidationMessages(BorderPane contentPane) {
        if (this.validationMessages.isEmpty()) {
            contentPane.setBottom(null);
            return;
        }
        VBox messagesPane = (VBox)contentPane.getBottom();
        if (messagesPane == null) {
            messagesPane = new VBox();
            contentPane.setBottom((Node)messagesPane);
        }
        ArrayList<ValidationMessageData> newMessages = new ArrayList<ValidationMessageData>((Collection<ValidationMessageData>)this.validationMessages);
        Iterator it = messagesPane.getChildren().iterator();
        while (it.hasNext()) {
            if (newMessages.remove(((Node)it.next()).getUserData())) continue;
            it.remove();
        }
        if (newMessages.isEmpty()) {
            return;
        }
        final ArrayList<ValidationMessageData> autoHideMessages = new ArrayList<ValidationMessageData>();
        for (ValidationMessageData data : newMessages) {
            IconNode icon;
            String typeClass;
            switch (data.message.getType()) {
                case ERROR: {
                    typeClass = "error";
                    icon = new IconNode(StandardIconShapes.VALIDATOR_ERROR, null, StandardIconIntentions.VALIDATOR_ERROR, null);
                    break;
                }
                case FOR_USER: 
                case MESSAGE: {
                    typeClass = "info";
                    icon = new IconNode(StandardIconShapes.VALIDATOR_MESSAGE, null, StandardIconIntentions.VALIDATOR_MESSAGE, null);
                    break;
                }
                case WARNING: {
                    typeClass = "warning";
                    icon = new IconNode(StandardIconShapes.VALIDATOR_WARNING, null, StandardIconIntentions.VALIDATOR_WARNING, null);
                    break;
                }
                default: {
                    typeClass = "warning";
                    icon = new IconNode(StandardIconShapes.VALIDATOR_WARNING, null, StandardIconIntentions.VALIDATOR_WARNING, null);
                }
            }
            HBox pane = new HBox();
            pane.setUserData((Object)data);
            pane.getStyleClass().addAll((Object[])new String[]{"message-pane", typeClass});
            CustomLabel label = new CustomLabel(data.message.getMessage().toString());
            label.setGraphic((Node)icon);
            pane.getChildren().add((Object)label);
            if (data.message.getDetails() != null) {
                Hyperlink detailsLink = new Hyperlink();
                detailsLink.setText(Messages.General_Details);
                detailsLink.setOnAction(event -> Dialog.message((Node)pane, Messages.General_Details, data.message.getDetails()));
                StackPane sp = new StackPane(new Node[]{detailsLink});
                sp.setAlignment(Pos.CENTER_LEFT);
                pane.getChildren().add((Object)sp);
                HBox.setHgrow((Node)sp, (Priority)Priority.ALWAYS);
            } else {
                HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
            }
            if (data.autoHide) {
                autoHideMessages.add(data);
            } else {
                StandardIconIntentions intention;
                switch (data.message.getType()) {
                    case ERROR: {
                        intention = StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_ERROR;
                        break;
                    }
                    case FOR_USER: 
                    case MESSAGE: {
                        intention = StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_MESSAGE;
                        break;
                    }
                    case WARNING: {
                        intention = StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_WARNING;
                        break;
                    }
                    default: {
                        intention = StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_WARNING;
                    }
                }
                IconNode clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, intention, null);
                clearButton.getStyleClass().addAll((Object[])new String[]{"clear-button"});
                Tooltip.install((Node)clearButton, (Tooltip)new Tooltip(Messages.General_Delete_message));
                clearButton.setOnMouseReleased(evt -> {
                    evt.consume();
                    this.validationMessages.remove((Object)data);
                });
                HBox.setHgrow((Node)clearButton, (Priority)Priority.NEVER);
                pane.getChildren().add((Object)clearButton);
            }
            messagesPane.getChildren().add((Object)pane);
        }
        if (!autoHideMessages.isEmpty()) {
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        1.sleep(5000 * autoHideMessages.size());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    FxUtil.submitToFxThread(() -> Dialog.this.validationMessages.removeAll((Collection)autoHideMessages));
                }
            }.start();
        }
    }

    private List<MenuItem> collectAdminTools() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        CustomMenuItem item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            StringBuilder buf = new StringBuilder();
            buf.append("Title: ").append(this.title).append('\n');
            buf.append("Message: ").append(this.message).append('\n');
            buf.append("Supplemental message: ").append(this.supMessage).append('\n');
            buf.append("Expand to parent: ").append(this.expand).append('\n');
            buf.append("Auto close: ").append(this.autoClose).append('\n');
            buf.append("On close request handler set: ").append(this.onCloseRequest != null).append('\n');
            buf.append("Buttons:\n");
            for (ButtonData bd : this.buttons) {
                buf.append(bd.style.name()).append('\t').append(bd.text).append('\n');
            }
            buf.append("Body:\n").append(this.body == null ? null : DevTools.getStructuredInfo(this.body));
            CustomTextArea widget = new CustomTextArea();
            widget.setText(buf.toString());
            widget.setMonospace(true);
            widget.setEditable(false);
            new Dialog().setTitle("Dialog UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this.dialogPane);
        });
        result.add((MenuItem)item);
        if (this.adminToolsSupplier != null) {
            result.addAll((Collection<MenuItem>)this.adminToolsSupplier.get());
        }
        return result;
    }

    private boolean acceptsDoubleClick(Node node) {
        if (node == null) {
            return false;
        }
        if (node instanceof DialogPane) {
            return false;
        }
        if (node instanceof TableView) {
            return true;
        }
        return this.acceptsDoubleClick((Node)node.getParent());
    }

    boolean isExpandToParent() {
        return this.expand;
    }
}

