/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.dicts;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.TextUtil;

public interface DictHandler<D extends BaseDictionary>
extends RegistryItem<DictHandler<?>> {
    public static final RegistryItemType<DictHandler<?>> TYPE = new RegistryItemType("DICT-HANDLER");

    public static DictHandler<?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    public static <D extends BaseDictionary> DictHandler<D> forDictClass(Class<D> dictClass) {
        return DictHandler.forDictClass(dictClass.getName());
    }

    public static <D extends BaseDictionary> DictHandler<D> forDictClass(String dictClassName) {
        for (DictHandler<?> handler : ClientRegistry.get().allOf(TYPE).values()) {
            if (!handler.getDictType().getName().equals(dictClassName)) continue;
            return handler;
        }
        return null;
    }

    public static String format(DictHandler<?> handler) {
        DictionaryType dt = (DictionaryType)MetaRegistry.get().getDictionaries().get(handler.getDictType().getName());
        return dt == null ? handler.getDictType().getSimpleName() : dt.getDisplayName();
    }

    @Override
    default public RegistryItemType<DictHandler<?>> getType() {
        return TYPE;
    }

    @Override
    default public String getId() {
        return this.getDictType().getName();
    }

    default public String format(D dict) {
        String result = dict.toString();
        if (result.startsWith("{")) {
            String code = dict.getCode();
            return TextUtil.isBlank((String)code) ? Messages.General_Without_name : code;
        }
        return result;
    }

    default public boolean isReadonly() {
        return false;
    }

    public Class<D> getDictType();

    public DictListParameters getStandardListParameters();

    public DictionaryReference<D> createReference(String var1);

    public ViewController<?, D> createEditorController();

    default public D createNewItem() {
        return null;
    }

    public boolean isAvaibleInConfiguration();
}

