/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.list;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.Action;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.lib.components.table.ProjectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPane;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.Referenceable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

public class IndexListPane<E extends BaseEntity, I extends EntityIndex<E>>
extends ListPane<I, IndexListPaneConfiguration<E, I>> {
    private static final boolean LIVE_FILTERS = "true".equalsIgnoreCase(System.getProperty("client.fx.entityList.liveFilters", "true"));
    private final Consumer<EntityModificationEvent> modificationEventHandler = evt -> {
        if (evt.getModifications().isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> this.handleModificationEvent((EntityModificationEvent)evt));
    };
    protected final Set<String> actionsAcl = new HashSet<String>();

    public static SearchCriterion createTextSearchCriterion(IndexType indexType, Collection<String> columnIds, String textSearchPattern) {
        String pattern = '%' + textSearchPattern.trim().toLowerCase() + '%';
        SearchCriterion result = null;
        for (String colId : columnIds) {
            IndexProperty prop = (IndexProperty)indexType.getProperties().get(colId);
            if (prop != null) {
                String propId = prop.getId();
                if (MetaRegistryHelper.isEntityReference((String)indexType.getId(), (String)prop.getId())) {
                    propId = propId + "ReferenceCaption";
                } else if (!"String".equals(prop.getType())) continue;
                if (result == null) {
                    result = SearchCriterion.ilike((String)propId, (String)pattern);
                    continue;
                }
                result = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{result, SearchCriterion.ilike((String)propId, (String)pattern)});
                continue;
            }
            IndexCollection coll = (IndexCollection)indexType.getCollections().get(colId);
            if (coll == null || !"String".equals(coll.getElementType())) continue;
            if (result == null) {
                result = SearchCriterion.ilike((String)coll.getId(), (String)pattern);
                continue;
            }
            result = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{result, SearchCriterion.ilike((String)coll.getId(), (String)pattern)});
        }
        return result;
    }

    private static boolean isKnownPropertyOrCollection(IndexType type, String id) {
        return type.getProperties().containsKey(id) || type.getCollections().containsKey(id);
    }

    protected void handleModificationEvent(EntityModificationEvent evt) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)this.getIndexType().getName());
        for (EntityModification mod : evt.getModifications()) {
            if (!MetaRegistryHelper.isAssignableFrom((EntityType)ett, (EntityType)MetaRegistryHelper.getEntityType((String)mod.getReference().getType().getName()))) continue;
            this.reloadData();
            return;
        }
    }

    public IndexListPane(ObservableMutex mutex, MultiSupplier<IndexListPaneConfiguration<E, I>> supplier) {
        super(supplier, mutex);
        this.selectConfiguration(0);
    }

    public IndexListPane(ObservableMutex mutex, final IndexListParameters<E, I> parameters, final SelectionMode selectionMode, final boolean actionsEnabled) {
        super(new MultiSupplier<IndexListPaneConfiguration<E, I>>(){

            @Override
            public int count() {
                return 1;
            }

            @Override
            public String getDisplayName(int idx) {
                return null;
            }

            @Override
            public IndexListPaneConfiguration<E, I> get(int idx) {
                IndexListPaneConfiguration result = new IndexListPaneConfiguration(parameters.getIndexType());
                result.setSelectionMode(selectionMode);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(actionsEnabled);
                result.setLimit(parameters.getLimit());
                result.applyParameters(parameters);
                return result;
            }
        }, mutex);
        this.selectConfiguration(0);
    }

    @Override
    protected void loadData(ObjIntConsumer<List<I>> callback) throws Exception {
        ValueHolder queryHolder = new ValueHolder();
        ArrayList projections = new ArrayList();
        FxUtil.waitForFxThread(() -> {
            queryHolder.set(this.buildQuery());
            projections.addAll(((IndexListPaneConfiguration)this.getConfiguration()).getProjections());
        });
        if (queryHolder.get() == null || this.isDisposed()) {
            return;
        }
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        List searchResult = entityService.search(ServiceInvocationContext.get(), ((IndexListPaneConfiguration)this.getConfiguration()).getIndexType(), (SearchQuery)queryHolder.get());
        if (this.isDisposed()) {
            return;
        }
        callback.accept(searchResult, ((SearchQuery)queryHolder.get()).getOffset());
        if (!PROJECTIONS_ENABLED || projections.isEmpty()) {
            return;
        }
        FxUtil.waitForFxThread(() -> this.setProjectionValues(projections.stream().map(field -> new Pair(field, (Object)"??")).collect(Collectors.toList())));
        if (this.isDisposed()) {
            return;
        }
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getCriteria().getCriterions().addAll(((SearchQuery)queryHolder.get()).getCriteria().getCriterions());
        projectionQuery.getCriteria().getRestrictions().addAll(((SearchQuery)queryHolder.get()).getCriteria().getRestrictions());
        projectionQuery.getCriteria().setFreeTextPattern(((SearchQuery)queryHolder.get()).getCriteria().getFreeTextPattern());
        int i = 0;
        block7: for (ProjectionField field : projections) {
            String alias = "value_" + i++;
            switch (field.getOperation()) {
                case COUNT: {
                    projectionQuery.getProjections().add(Projection.rowCount((String)alias));
                    continue block7;
                }
                case AVERAGE: {
                    projectionQuery.getProjections().add(Projection.avg((String)field.getId(), (String)alias));
                    continue block7;
                }
                case MAX: {
                    projectionQuery.getProjections().add(Projection.max((String)field.getId(), (String)alias));
                    continue block7;
                }
                case MIN: {
                    projectionQuery.getProjections().add(Projection.min((String)field.getId(), (String)alias));
                    continue block7;
                }
                case SUM: {
                    projectionQuery.getProjections().add(Projection.sum((String)field.getId(), (String)alias));
                    continue block7;
                }
            }
            throw Xeption.forDeveloper((String)"unsupported projection operation {0}", (Object[])new Object[]{field.getOperation().name()});
        }
        ProjectionResult projectionResult = entityService.search(ServiceInvocationContext.get(), ((IndexListPaneConfiguration)this.getConfiguration()).getIndexType(), projectionQuery);
        if (this.isDisposed()) {
            return;
        }
        i = 0;
        ArrayList<Pair> projectionValues = new ArrayList<Pair>(projections.size());
        for (ProjectionField field : projections) {
            Object value = projectionResult.get("value_" + i++);
            projectionValues.add(new Pair((Object)field, (Object)(value == null ? "??" : StandardRenderers.toString(value))));
        }
        FxUtil.submitToFxThread(() -> this.setProjectionValues(projectionValues));
    }

    public SearchQuery buildQuery() {
        String pattern;
        if (this.getTableView() == null) {
            return null;
        }
        IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(this.getIndexType().getName());
        SearchQuery result = new SearchQuery();
        result.setLimit(((IndexListPaneConfiguration)this.getConfiguration()).getLimit());
        result.setOffset(this.getOffset());
        result.getCriteria().getCriterions().addAll(((IndexListPaneConfiguration)this.getConfiguration()).getSearchCriterions());
        result.getCriteria().getRestrictions().addAll(((IndexListPaneConfiguration)this.getConfiguration()).getRestrictions());
        if (indexType.getInterfaces().contains(Referenceable.class.getName())) {
            result.getPreferredProperties().add("ref");
        }
        if (!TextUtil.isBlank((String)(pattern = this.getPatternText()))) {
            pattern = pattern.trim();
            if (!GlobalSettingsService.get().isRestrictedTextSearch() || pattern.length() > 2) {
                if (((IndexListPaneConfiguration)this.getConfiguration()).getPatternSearchFields().isEmpty()) {
                    result.getCriteria().setFreeTextPattern(pattern);
                } else {
                    result.getCriteria().getCriterions().add(IndexListPane.createTextSearchCriterion(indexType, ((IndexListPaneConfiguration)this.getConfiguration()).getPatternSearchFields(), pattern));
                }
            }
        }
        for (TableColumn tableColumn : this.getTableView().getColumns()) {
            if (!IndexListPane.isKnownPropertyOrCollection(indexType, tableColumn.getId()) || !tableColumn.isVisible() || tableColumn.getId() == null) continue;
            result.getPreferredProperties().add(tableColumn.getId());
        }
        for (Map.Entry<String, SortOrder> entry : this.getSortOrder().entrySet()) {
            if (!IndexListPane.isKnownPropertyOrCollection(indexType, entry.getKey()) || entry.getValue() == null) continue;
            result.getCriteria().getOrders().put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getFiltersData().entrySet()) {
            Object value;
            String propertyId = entry.getKey();
            if (!IndexListPane.isKnownPropertyOrCollection(indexType, propertyId)) continue;
            List values = (List)entry.getValue();
            if (values.size() == 1 && values.get(0) != null) {
                value = values.get(0);
                if (value instanceof String) {
                    result.getCriteria().getCriterions().add(SearchCriterion.ilike((String)propertyId, (String)('%' + String.valueOf(value).trim().toLowerCase() + '%')));
                    continue;
                }
                if (indexType.getCollections().containsKey(propertyId)) {
                    if (value.getClass().isEnum()) {
                        value = ((Enum)value).name();
                    }
                    result.getCriteria().getCriterions().add(SearchCriterion.contains((String)propertyId, value));
                    continue;
                }
                result.getCriteria().getCriterions().add(SearchCriterion.eq((String)propertyId, value));
                continue;
            }
            if (values.size() != 2) continue;
            value = values.get(0);
            if (value != null) {
                if (value instanceof Date) {
                    value = MiscUtil.clearTime((Date)((Date)value));
                }
                result.getCriteria().getCriterions().add(SearchCriterion.ge((String)propertyId, value));
            }
            if ((value = values.get(1)) == null) continue;
            if (value instanceof Date) {
                value = MiscUtil.setDayEndTime((Date)((Date)value));
            }
            result.getCriteria().getCriterions().add(SearchCriterion.le((String)propertyId, value));
        }
        if (!result.getPreferredProperties().isEmpty()) {
            result.getPreferredProperties().addAll(indexType.getProperties().values().stream().filter(IndexProperty::isFxImplicit).map(BaseMetaElement::getId).collect(Collectors.toSet()));
            result.getPreferredProperties().addAll(indexType.getCollections().values().stream().filter(IndexCollection::isFxImplicit).map(BaseMetaElement::getId).collect(Collectors.toSet()));
        }
        return result;
    }

    @Override
    protected FilterHandler createFilterHandler(TableColumnSettings filter, Supplier<List<?>> itemsSupplier) throws Exception {
        IndexCollection coll;
        IndexProperty prop;
        Map parameters;
        String filterFactoryId;
        IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(this.getIndexType().getName());
        if (indexType != null && (filterFactoryId = (String)(parameters = (prop = (IndexProperty)indexType.getProperties().get(filter.getId())) != null ? prop.getParameters() : ((coll = (IndexCollection)indexType.getCollections().get(filter.getId())) != null ? coll.getParameters() : Collections.emptyMap())).get("fx-filter-factory-id")) != null) {
            ListPaneFilterFactory factory = ListPaneFilterFactory.forId(filterFactoryId);
            return factory == null ? null : factory.createFor(filter, itemsSupplier);
        }
        return super.createFilterHandler(filter, itemsSupplier);
    }

    @Override
    protected Function<String, Supplier<List<?>>> getFilterItemsSuppliers() {
        return id -> {
            if (!LIVE_FILTERS) {
                return null;
            }
            MetaRegistry metaRegistry = MetaRegistry.get();
            IndexType indexType = (IndexType)metaRegistry.getIndexes().get(this.getIndexType().getName());
            if (indexType == null) {
                return null;
            }
            IndexProperty prop = (IndexProperty)indexType.getProperties().get(id);
            if (prop == null || !prop.isFilterable()) {
                return null;
            }
            if ("String".equals(prop.getType()) || metaRegistry.getEnums().containsKey(prop.getType()) || metaRegistry.getEnumRefs().containsKey(prop.getType()) || metaRegistry.getDictionaries().containsKey(prop.getType()) || metaRegistry.getEntities().containsKey(prop.getType()) || metaRegistry.getEntityRefs().containsKey(prop.getType())) {
                return () -> {
                    try {
                        ServiceInvocationContext sic = ServiceInvocationContext.get();
                        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                        SearchQuery query = new SearchQuery();
                        query.getCriteria().getCriterions().addAll(((IndexListPaneConfiguration)this.getConfiguration()).getSearchCriterions());
                        query.getCriteria().getRestrictions().addAll(((IndexListPaneConfiguration)this.getConfiguration()).getRestrictions());
                        return entityService.getValuesForFilter(sic, ((IndexListPaneConfiguration)this.getConfiguration()).getIndexType(), prop.getId(), query.getCriteria());
                    }
                    catch (Exception e) {
                        ErrorHandler.handle(e);
                        return Collections.emptyList();
                    }
                };
            }
            return null;
        };
    }

    @Override
    protected String getQueryInfo() {
        ValueHolder queryHolder = new ValueHolder();
        try {
            FxUtil.waitForFxThread(() -> queryHolder.set(this.buildQuery()));
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
        return ((IndexListPaneConfiguration)this.getConfiguration()).getIndexType().getName() + ' ' + Optional.ofNullable(queryHolder.get()).map(Object::toString).orElse("?");
    }

    @Override
    protected Object getItemValue(I item, String columnId) {
        return item.getValue(columnId);
    }

    @Override
    protected ActionsPane<?> createActionsPane() {
        ActionsPane<IndexListAction> result = new ActionsPane<IndexListAction>(){

            @Override
            protected boolean isDefault(IndexListAction action) {
                return action.isDefault();
            }

            @Override
            protected boolean isEnabled(IndexListAction action) {
                if (IndexListPane.this.getMutex().isAcquired() || !IndexListPane.this.actionsAcl.contains(action.getId())) {
                    return false;
                }
                return action.isEnabled(IndexListPane.this);
            }

            @Override
            protected void execute(Control source, IndexListAction action, boolean alt) {
                action.execute(source, IndexListPane.this, alt);
            }

            @Override
            protected String getName(IndexListAction action) {
                return action.getName(IndexListPane.this);
            }

            @Override
            protected String getDescription(IndexListAction action) {
                return action.getDescription(IndexListPane.this);
            }

            @Override
            protected ActionIcon getIcon(IndexListAction action) {
                return action.getIcon(IndexListPane.this);
            }
        };
        result.populate(this.collectActions());
        return result;
    }

    protected List<IndexListAction> collectActions() {
        return ClientRegistry.get().allOf(IndexListAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList());
    }

    @Override
    protected <A extends Action<?>> void executeAction(Control source, A action) {
        IndexListAction ila = (IndexListAction)action;
        if (ila.isEnabled(this)) {
            ila.execute(source, this, false);
        }
    }

    @Override
    protected AclQuery getListACLQuery() {
        return new AclQuery(StandardRestrictionResourceOperations.VIEW.getId(), this.getIndexType().getName());
    }

    public Class<I> getIndexType() {
        return ((IndexListPaneConfiguration)this.getConfiguration()).getIndexType();
    }

    public Consumer<EntityModificationEvent> getModificationEventHandler() {
        return this.modificationEventHandler;
    }

    @Override
    protected void newConfigurationPopulated() {
        super.newConfigurationPopulated();
        ActionsPane<?> actionsPane = this.getActionsPane();
        if (actionsPane == null) {
            return;
        }
        this.actionsAcl.clear();
        Notifications.get().submitTask(() -> {
            HashSet<String> enabled = new HashSet<String>();
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (IndexListAction action : this.collectActions()) {
                AclQuery query = action.getACLQuery(this);
                if (query == null) {
                    enabled.add(action.getId());
                    continue;
                }
                map.put(action.getId(), query);
            }
            Set<String> granted = FxAclUtil.applyACL(map);
            this.actionsAcl.clear();
            this.actionsAcl.addAll(enabled);
            this.actionsAcl.addAll(granted);
            FxUtil.submitToFxThread(actionsPane::revalidate);
        }, this.getMutex());
    }

    @Override
    protected void buildConfigurationInfo(StringBuilder buf, IndexListPaneConfiguration<E, I> config) {
        super.buildConfigurationInfo(buf, config);
        buf.append("Index class: ").append(config.getIndexType().getName()).append('\n');
        buf.append("Query: ").append(this.buildQuery().toString()).append('\n');
        buf.append("Actions (class, ID, title [flags]):\n");
        for (IndexListAction action : this.collectActions()) {
            buf.append('\t').append(action.getClass().getName()).append('\t').append(action.getId()).append('\t').append(action.getName(this));
            if (!action.isEnabled(this)) {
                buf.append(" [disabled]");
            }
            if (!this.actionsAcl.contains(action.getId())) {
                buf.append(" [forbidden]");
            }
            buf.append('\n');
        }
    }
}

