/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BaseCollectionField;
import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataContext;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DoubleValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.IntValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.DictBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

class CollectionFieldSimpleEntity<E>
extends BaseCollectionField<E> {
    private final TableWidgetController<TableWidget<Object>, Object> controller;

    static boolean isApplicableTo(EntityType ett, MetadataContext ctx) {
        if (MetaRegistryHelper.getAllCollections((BaseClassType)ett).values().stream().filter(coll -> ctx.getFieldFilter().test(ett, coll.getId())).count() > 0L) {
            return false;
        }
        for (Property prop : MetaRegistryHelper.getAllProperties((EntityType)ett).values()) {
            if (!ctx.getFieldFilter().test(ett, prop.getId()) || ColumnHandler.forProperty(prop) != null) continue;
            return false;
        }
        return true;
    }

    CollectionFieldSimpleEntity(Class<E> entityClass, EntityCollection coll, MetadataContext ctx) throws Exception {
        super(entityClass, coll);
        Class itemClass = XSHelper.getClass((String)coll.getElementType());
        final TableWidget<Object> widget = new TableWidget<Object>(false);
        widget.setItemsProvider(() -> {
            try {
                return itemClass.newInstance();
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"failed instanciating object of type {0}", (Throwable)e, (Object[])new Object[]{itemClass.getName()});
            }
        });
        if (List.class.getName().equals(coll.getType())) {
            widget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        }
        ArrayList columns = new ArrayList();
        EntityType ett = (EntityType)MetaRegistry.get().getEntities().get(coll.getElementType());
        for (Property prop : MetaRegistryHelper.getAllProperties((EntityType)ett).values()) {
            if (!ctx.getFieldFilter().test(ett, prop.getId())) continue;
            TableWidgetColumn<Object, ?> column = ColumnHandler.forProperty(prop).createColumn(prop);
            column.setCaption(ctx.getLabel(ett, (BaseMetaElement)prop));
            columns.add(column);
        }
        widget.setColumns(columns);
        this.controller = new TableWidgetController<TableWidget<Object>, Object>(){

            @Override
            public TableWidget<Object> getView() {
                return widget;
            }
        };
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(GridCell.NEW_ROW_MARKER);
        GridCell cell = new GridCell(label, this.controller.getView());
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
    }

    @Override
    void readData(E entity) {
        this.controller.readData((Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id));
    }

    @Override
    void writeData(E entity) {
        this.controller.writeData((Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id));
    }

    @Override
    void setReadonly(boolean readonly) {
        this.controller.setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return this.controller.isDataChanged();
    }

    @Override
    void setNotEditable(boolean notEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        ((TableWidget)this.controller.getView()).getViewState().setAclNotEditable(aclNotEditable);
    }

    private static enum ColumnHandler {
        STRING{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return "String".equals(prop.getType()) || "text".equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                TextWidgetColumn<Object> result = new TextWidgetColumn<Object>(obj -> obj == null ? null : (String)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        DATE{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return Date.class.getName().equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                DateValueWidgetColumn<Object> result = new DateValueWidgetColumn<Object>(obj -> obj == null ? null : DateUtils.asLocalDate((Date)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId())), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)DateUtils.asDate(val)));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        BOOLEAN{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return "boolean".equals(prop.getType()) || "Boolean".equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                BooleanValueWidgetColumn<Object> result = new BooleanValueWidgetColumn<Object>(obj -> obj == null ? null : (Boolean)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        INT{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return "int".equals(prop.getType()) || "Integer".equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                IntValueWidgetColumn<Object> result = new IntValueWidgetColumn<Object>(obj -> obj == null ? null : (Integer)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        DOUBLE{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return "double".equals(prop.getType()) || "Double".equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                DoubleValueWidgetColumn<Object> result = new DoubleValueWidgetColumn<Object>(obj -> obj == null ? null : (Double)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        PRICE{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return BigDecimal.class.getName().equals(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) {
                PriceValueWidgetColumn<Object> result = new PriceValueWidgetColumn<Object>(obj -> obj == null ? null : (BigDecimal)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        ENUM{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return MetaRegistry.get().getEnums().containsKey(prop.getType());
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) throws Exception {
                ComboBoxWidgetColumn<Object, Object> result = new ComboBoxWidgetColumn<Object, Object>(obj -> obj == null ? null : ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                Supplier supplier = Suppliers.createEnumSupplier(XSHelper.getClass((String)prop.getType()));
                result.setItemsSupplier(supplier);
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        ENTITY_REF{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return prop.isReference() && MetaRegistry.get().getEntities().get(prop.getType()) != null;
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) throws Exception {
                EntityBoxWidgetColumn result = new EntityBoxWidgetColumn(XSHelper.getClass((String)prop.getType()), obj -> obj == null ? null : (EntityReference)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        }
        ,
        DICT{

            @Override
            protected boolean isApplicableTo(Property prop) {
                return MetaRegistry.get().getDictionaries().get(prop.getType()) != null;
            }

            @Override
            protected TableWidgetColumn<Object, ?> createColumn(Property prop) throws Exception {
                DictBoxWidgetColumn result = new DictBoxWidgetColumn(XSHelper.getClass((String)prop.getType()), obj -> obj == null ? null : (DictionaryReference)ReflectionUtil.getValue(obj.getClass(), (Object)obj, (String)prop.getId()), (obj, val) -> ReflectionUtil.setValue(obj.getClass(), (Object)obj, (String)prop.getId(), (Object)val));
                result.setId(prop.getId());
                return result;
            }
        };


        static ColumnHandler forProperty(Property prop) {
            for (ColumnHandler columnHandler : ColumnHandler.values()) {
                if (!columnHandler.isApplicableTo(prop)) continue;
                return columnHandler;
            }
            return null;
        }

        protected abstract boolean isApplicableTo(Property var1);

        protected abstract TableWidgetColumn<Object, ?> createColumn(Property var1) throws Exception;
    }
}

