/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BaseCollectionField;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class CollectionFieldUnsupported<E>
extends BaseCollectionField<E> {
    private final TableWidgetController<TableWidget<ValueHolder<String>>, ValueHolder<String>> controller;
    private final String elementType;

    CollectionFieldUnsupported(Class<E> entityClass, EntityCollection coll) throws Exception {
        super(entityClass, coll);
        final TableWidget widget = new TableWidget(true);
        widget.setItemsProvider(() -> new ValueHolder());
        widget.getViewState().setNotEditable(true);
        ArrayList columns = new ArrayList();
        TextWidgetColumn<ValueHolder> column = new TextWidgetColumn<ValueHolder>(vh -> (String)vh.get(), (vh, value) -> vh.set(value));
        column.setId("value");
        column.setNotEditable(true);
        columns.add(column);
        widget.setColumns(columns);
        this.controller = new TableWidgetController<TableWidget<ValueHolder<String>>, ValueHolder<String>>(){

            @Override
            public TableWidget<ValueHolder<String>> getView() {
                return widget;
            }
        };
        this.elementType = coll.getElementType();
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(GridCell.NEW_ROW_MARKER);
        GridCell cell = new GridCell(label, this.controller.getView());
        cell.setColSpan(Integer.MAX_VALUE);
        cell.setHelp(() -> new QuickHelp(String.format("<html>Unsupported collection field for elements of type <b>%s</b>", this.elementType)));
        cells.add(cell);
    }

    @Override
    void readData(E entity) {
        this.controller.readData(((Collection)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id)).stream().map(val -> new ValueHolder(StandardRenderers.GENERIC.apply(val))).collect(Collectors.toList()));
    }

    @Override
    void writeData(E entity) {
    }

    @Override
    void setReadonly(boolean readonly) {
    }

    @Override
    boolean isDataChanged() {
        return false;
    }

    @Override
    void setNotEditable(boolean notEditable) {
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
    }
}

