/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.EntityField;
import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataContext;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;

public class MetadataBasedEditor<E extends BaseEntity>
extends GridContainer {
    public static final BiPredicate<EntityType, String> STANDARD_FILTER = (ett, field) -> {
        Property prop = (Property)ett.getProperties().get(field);
        if (prop != null && "true".equals(prop.getParameters().get("hidden"))) {
            return false;
        }
        EntityCollection coll = (EntityCollection)ett.getCollections().get(field);
        return coll == null || !"true".equals(coll.getParameters().get("hidden"));
    };
    private final List<EntityField<E>> fields = new ArrayList<EntityField<E>>();

    public static <E extends BaseEntity> ViewController<MetadataBasedEditor<E>, EntityContainer<E>> createController(EntityType entityType, BiPredicate<EntityType, String> fieldFilter) throws Exception {
        final MetadataBasedEditor<E> editor = new MetadataBasedEditor<E>(entityType, fieldFilter);
        return new ViewController<MetadataBasedEditor<E>, EntityContainer<E>>(){
            private EntityContainer<E> data;
            private boolean readonly;

            @Override
            public MetadataBasedEditor<E> getView() {
                return editor;
            }

            @Override
            public EntityContainer<E> getData() {
                return this.data;
            }

            @Override
            public void readData(EntityContainer<E> model) {
                this.data = model;
                editor.readData(model.getEntity());
            }

            @Override
            public void writeData(EntityContainer<E> model) {
                this.data = model;
                editor.writeData(model.getEntity());
            }

            @Override
            public boolean isReadonly() {
                return this.readonly;
            }

            @Override
            public void setReadonly(boolean value) {
                this.readonly = value;
                editor.setReadonly(value);
            }

            @Override
            public void setNotEditable(boolean value) {
                editor.setNotEditable(value);
            }

            @Override
            public void setAclNotEditable(boolean aclNotEditable) {
                editor.setAclNotEditable(aclNotEditable);
            }

            @Override
            public boolean isDataChanged() {
                return editor.isDataChanged();
            }

            @Override
            public void validateData(List<Message> messages) {
            }
        };
    }

    MetadataBasedEditor(EntityType entityType, BiPredicate<EntityType, String> fieldFilter) throws Exception {
        super(4);
        EntityField field;
        MetadataContext ctx = new MetadataContext(fieldFilter);
        Class cls = XSHelper.getClass((String)entityType.getId());
        ArrayList cells = new ArrayList();
        for (Property prop : MetaRegistryHelper.getAllProperties((EntityType)entityType).values()) {
            if (!fieldFilter.test(entityType, prop.getId())) continue;
            field = EntityField.forProperty(cls, prop);
            this.fields.add(field);
            field.buildUI(cells, ctx.getLabel(entityType, (BaseMetaElement)prop));
        }
        for (EntityCollection coll : MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values()) {
            if (!fieldFilter.test(entityType, coll.getId())) continue;
            field = EntityField.forCollection(cls, coll, ctx);
            this.fields.add(field);
            field.buildUI(cells, ctx.getLabel(entityType, (BaseMetaElement)coll));
        }
        this.getCells().addAll(cells);
    }

    void readData(E model) {
        for (EntityField<E> field : this.fields) {
            field.readData(model);
        }
    }

    void writeData(E model) {
        for (EntityField<E> field : this.fields) {
            field.writeData(model);
        }
    }

    void setReadonly(boolean readonly) {
        for (EntityField<E> field : this.fields) {
            field.setReadonly(readonly);
        }
    }

    boolean isDataChanged() {
        for (EntityField<E> field : this.fields) {
            if (!field.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    public void setNotEditable(boolean notEditable) {
        for (EntityField<E> field : this.fields) {
            field.setNotEditable(notEditable);
        }
    }

    public void setAclNotEditable(boolean aclNotEditable) {
        for (EntityField<E> field : this.fields) {
            field.setAclNotEditable(aclNotEditable);
        }
    }
}

