/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BasePropertyField;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

class PropertyFieldDateTime<E>
extends BasePropertyField<E> {
    private final DateTimeValueWidget widget = new DateTimeValueWidget(false);
    private Date value;

    PropertyFieldDateTime(Class<E> entityClass, Property prop) throws Exception {
        super(entityClass, prop);
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        cells.add(new GridCell<DateTimeValueWidget>(label, this.widget));
    }

    @Override
    void readData(E entity) {
        this.value = (Date)ReflectionUtil.getValue((Class)this.cls, entity, (String)this.id);
        this.widget.valueProperty().set((Object)DateUtils.asLocalDateTime(this.value));
    }

    @Override
    void writeData(E entity) {
        this.value = DateUtils.asDate((LocalDateTime)this.widget.valueProperty().get());
        ReflectionUtil.setValue((Class)this.cls, entity, (String)this.id, (Object)this.value);
    }

    @Override
    void setReadonly(boolean readonly) {
        this.widget.getViewState().setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return !MiscUtil.equals((Object)this.value, (Object)this.widget.valueProperty().get());
    }

    @Override
    void setNotEditable(boolean notEditable) {
        this.widget.getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        this.widget.getViewState().setAclNotEditable(aclNotEditable);
    }
}

