/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.entity.metadata;

import com.gridnine.xtrip.client.fx.core.entity.metadata.BasePropertyField;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import java.util.List;

class PropertyFieldNestedEntityReference<E extends BaseEntity, N extends BaseEntity>
extends BasePropertyField<E> {
    private final NestedEntityBoxWidget<E, N> widget;
    private NestedEntityReference<E, N> value;

    PropertyFieldNestedEntityReference(Class<E> entityClass, Class<N> nestedClass, Property prop) throws Exception {
        super(entityClass, prop);
        this.widget = new NestedEntityBoxWidget<E, N>(entityClass, nestedClass, false);
    }

    @Override
    void buildUI(List<GridCell<?>> cells, String label) {
        this.widget.setFieldName(label);
        cells.add(new GridCell<NestedEntityBoxWidget<E, N>>(label, this.widget));
    }

    @Override
    void readData(E entity) {
        this.value = (NestedEntityReference)ReflectionUtil.getValue(entity.getClass(), entity, (String)this.id);
        this.widget.valueProperty().set(this.value);
    }

    @Override
    void writeData(E entity) {
        this.value = (NestedEntityReference)this.widget.valueProperty().get();
        ReflectionUtil.setValue(entity.getClass(), entity, (String)this.id, this.value);
    }

    @Override
    void setReadonly(boolean readonly) {
        this.widget.getViewState().setReadonly(readonly);
    }

    @Override
    boolean isDataChanged() {
        return !MiscUtil.equals(this.value, (Object)this.widget.valueProperty().get());
    }

    @Override
    void setNotEditable(boolean notEditable) {
        this.widget.getViewState().setNotEditable(notEditable);
    }

    @Override
    void setAclNotEditable(boolean aclNotEditable) {
        this.widget.getViewState().setAclNotEditable(aclNotEditable);
    }
}

