/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.factory;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsSupplier;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsTracker;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import java.util.Collection;

class ProxyFactoryTool
implements FactoryTool {
    private final String uid;
    private final String name;
    private final FactoryToolCategory category;
    private final boolean auxiliary;

    ProxyFactoryTool(String ud, String nm, FactoryToolCategory ctg, boolean aux) {
        this.uid = ud;
        this.name = nm;
        this.category = ctg;
        this.auxiliary = aux;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getWeight() {
        return 0.0;
    }

    @Override
    public FactoryToolCategory getCategory() {
        return this.category;
    }

    @Override
    public boolean isAuxiliary() {
        return this.auxiliary;
    }

    @Override
    public void execute() {
        Notifications.get().submitTask(this::lookupAndExecute, Messages.General_Looking_for_boot_tool + ": " + this.name);
    }

    private void lookupAndExecute() {
        ValueHolder<FactoryTool> tool = new ValueHolder<FactoryTool>();
        block0: for (FactoryToolsSupplier supplier : ClientRegistry.get().allOf(FactoryToolsSupplier.TYPE).values()) {
            for (FactoryTool ft : (Collection)supplier.get()) {
                if (!this.uid.equals(ft.getUid())) continue;
                tool.set(ft);
                break block0;
            }
        }
        FxUtil.submitToFxThread(() -> {
            if (tool.get() != null) {
                FactoryToolsTracker.onExecute((FactoryTool)tool.get());
                ((FactoryTool)tool.get()).execute();
            } else {
                FactoryToolsTracker.remove(this.uid);
                Dialog.info(Messages.General_Boot_tool_not_found);
            }
        });
    }

    @Override
    public AclQuery getACLQuery() {
        return null;
    }
}

