/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.factory;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.common.Environment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

class ToolsStat {
    private static volatile ToolsStat instance;
    private final Map<String, Integer> data = new HashMap<String, Integer>();

    static synchronized ToolsStat get() {
        if (instance == null) {
            instance = new ToolsStat();
            instance.load();
        }
        return instance;
    }

    private static File getDataFile() {
        File file = new File(Environment.getDataFolder(), "settings/factory-tools-stat.dat");
        return file;
    }

    private ToolsStat() {
    }

    void onExecute(FactoryTool tool) {
        this.data.put(tool.getUid(), this.data.getOrDefault(tool.getUid(), 0) + 1);
        this.save();
    }

    void remove(String toolUid) {
        if (this.data.remove(toolUid) != null) {
            this.save();
        }
    }

    Stream<String> getPopular() {
        return this.data.entrySet().stream().sorted((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue())).map(entry -> (String)entry.getKey());
    }

    private void load() {
        File file = ToolsStat.getDataFile();
        if (!file.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (BufferedReader in = Files.newBufferedReader(file.toPath());){
            props.load(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.data.put(String.valueOf(entry.getKey()), Integer.valueOf(String.valueOf(entry.getValue())));
        }
    }

    private void save() {
        File file = ToolsStat.getDataFile();
        Properties props = new Properties();
        for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue().toString());
        }
        try (BufferedWriter out = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            props.store(out, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

