/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.BooleanColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ComboBoxColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.DateColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.DateTimeColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.KeyValueColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.NestedEntityReferenceColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.PriceColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.StringColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.SuperColumn;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.UiWidgetBigTableBox;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.util.Pair;

enum BigTableWidgets {
    STRING{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, String> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, String> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{StringColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    DATE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, LocalDate.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, LocalDate.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{DateColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    DATE_TIME{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, LocalDateTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, LocalDateTime.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{DateTimeColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    PRICE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, BigDecimal.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, BigDecimal.class.getName(), GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{PriceColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    ACTION{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, String> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter);", new Object[]{ActionColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    BOOLEAN{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            writer.code("%s<%s, Boolean> getter = obj -> obj.is%s();", new Object[]{Function.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, Boolean> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s> column = new %1$s<>(getter, setter);", new Object[]{BooleanColumn.class.getName(), modelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    COMBO_BOX{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String comboBoxClassName = ((UiWidgetBigTableBox.ComboBoxColumn)column).getModelClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, comboBoxClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, comboBoxClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{ComboBoxColumn.class.getName(), modelClassName, comboBoxClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    KEY_VALUE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String keyModelClassName = ((UiWidgetBigTableBox.KeyValueColumn)column).getKeyModelClassName();
            String valueClassName = String.format("%s<%s, Object>", Pair.class.getName(), keyModelClassName);
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, valueClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s> column = new %1$s<>(getter, setter);", new Object[]{KeyValueColumn.class.getName(), modelClassName, keyModelClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    SUPER{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            BaseUiContainer payloadCtr = (BaseUiContainer)ctx.getUiMetaRegistry().getContainers().get(((UiWidgetBigTableBox.SuperColumn)column).getPayload().getId());
            String payloadModelClassName = payloadCtr.getModel().getClassName();
            writer.code("%s<%s, %s> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, payloadModelClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s<%s, %s>> supplier = () -> new %s(new %3$s(%sNode.getViewState().isReadonly()), %6$sNode.getViewState().isReadonly());", new Object[]{Supplier.class.getName(), ViewController.class.getName(), payloadCtr.getId(), payloadModelClassName, payloadCtr.getId() + "Controller", name});
            writer.code("%s<%s, %s, %s> column = new %1$s<>(getter, supplier);", new Object[]{SuperColumn.class.getName(), modelClassName, payloadModelClassName, payloadCtr.getId()});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    }
    ,
    NESTED_ENTITY_REFERENCE{

        @Override
        void generateWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, String name, UiWidgetBigTableBox.BaseColumn column) throws Exception {
            String modelClassName = widget.getModel().getClassName();
            String rootClassName = ((UiWidgetBigTableBox.NestedEntityReferenceColumn)column).getRootModelClassName();
            String nestedClassName = ((UiWidgetBigTableBox.NestedEntityReferenceColumn)column).getNestedModelClassName();
            writer.code("%s<%s, %s<%s, %s>> getter = obj -> obj.get%s();", new Object[]{Function.class.getName(), modelClassName, NestedEntityReference.class.getName(), rootClassName, nestedClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s<%s, %s>> setter = (obj, value) -> obj.set%s(value);", new Object[]{BiConsumer.class.getName(), modelClassName, NestedEntityReference.class.getName(), rootClassName, nestedClassName, GenUtil.capitalize((String)column.getId())});
            writer.code("%s<%s, %s, %s> column = new %1$s<>(%3$s.class, %4$s.class, getter, setter);", new Object[]{NestedEntityReferenceColumn.class.getName(), modelClassName, rootClassName, nestedClassName});
            this.configureWidgetColumn(writer, ctx, widget, column);
            writer.code("columns.add(column);", new Object[0]);
        }
    };


    static BigTableWidgets getFor(UiWidgetBigTableBox.BaseColumn column) {
        if (column instanceof UiWidgetBigTableBox.ComboBoxColumn) {
            return COMBO_BOX;
        }
        if (column instanceof UiWidgetBigTableBox.NestedEntityReferenceColumn) {
            return NESTED_ENTITY_REFERENCE;
        }
        if (column instanceof UiWidgetBigTableBox.KeyValueColumn) {
            return KEY_VALUE;
        }
        if (column instanceof UiWidgetBigTableBox.SuperColumn) {
            return SUPER;
        }
        if (!(column instanceof UiWidgetBigTableBox.SimpleColumn)) {
            throw Xeption.forDeveloper((String)("unsupported column class " + column.getClass().getName()), (Object[])new Object[0]);
        }
        UiWidgetBigTableBox.ColumnType type = ((UiWidgetBigTableBox.SimpleColumn)column).getType();
        switch (type) {
            case STRING: {
                return STRING;
            }
            case DATE: {
                return DATE;
            }
            case DATE_TIME: {
                return DATE_TIME;
            }
            case PRICE: {
                return PRICE;
            }
            case ACTION: {
                return ACTION;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
        }
        throw Xeption.forDeveloper((String)("unsupported simple column type " + type), (Object[])new Object[0]);
    }

    abstract void generateWidgetColumn(JavaWriter var1, GenerationContext var2, UiWidgetBigTableBox var3, String var4, UiWidgetBigTableBox.BaseColumn var5) throws Exception;

    protected void configureWidgetColumn(JavaWriter writer, GenerationContext ctx, UiWidgetBigTableBox widget, UiWidgetBigTableBox.BaseColumn column) throws Exception {
        CodeGenHelper.genForLabel(column.getCaption(), writer, "column", "setCaption");
        CodeGenHelper.genSetHelp(column.getHelp(), writer, "column");
        writer.code("column.setId(\"%s\");", new Object[]{column.getId()});
        if (column.isNotEditable()) {
            writer.code("column.setNotEditable(true);", new Object[0]);
        }
        if (column.getPrefWidthEm() != null) {
            writer.code("column.setPrefWidthEm(Double.valueOf(%s));", new Object[]{column.getPrefWidthEm()});
        }
        if (column.getMaxWidthEm() != null) {
            writer.code("column.setMaxWidthEm(Double.valueOf(%s));", new Object[]{column.getMaxWidthEm()});
        }
        if (column.getMinWidthEm() != null) {
            writer.code("column.setMinWidthEm(Double.valueOf(%s));", new Object[]{column.getMinWidthEm()});
        }
    }
}

