/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import java.io.IOException;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang.StringEscapeUtils;

final class CodeGenHelper {
    static void genForLabel(UiLabel label, JavaWriter writer, String varName, String methodName) throws IOException {
        if (label == null) {
            return;
        }
        if (label.getId() == null) {
            writer.code("%s.%s(\"%s\");", new Object[]{varName, methodName, StringEscapeUtils.escapeJava((String)label.toString())});
        } else {
            writer.beginBlock();
            writer.code("%s uiLabel = %s.get().getLabels().get(\"%s\");", new Object[]{UiLabel.class.getName(), UiMetaRegistry.class.getName(), label.getId()});
            writer.code("%s.%s(uiLabel == null ? \"%s\" : uiLabel.toString());", new Object[]{varName, methodName, label.getId()});
            writer.endBlock();
        }
    }

    static void genLabelVar(UiLabel label, JavaWriter writer, String varName) throws IOException {
        if (label == null) {
            writer.code("String %s = null;", new Object[]{varName});
        } else if (label.getId() == null) {
            writer.code("String %s = \"%s\";", new Object[]{varName, StringEscapeUtils.escapeJava((String)label.toString())});
        } else {
            writer.code("String %s;", new Object[]{varName});
            writer.beginBlock();
            writer.code("%s uiLabel = %s.get().getLabels().get(\"%s\");", new Object[]{UiLabel.class.getName(), UiMetaRegistry.class.getName(), label.getId()});
            writer.code("%s = (uiLabel == null) ? \"%s\" : uiLabel.toString();", new Object[]{varName, label.getId()});
            writer.endBlock();
        }
    }

    static void genSetHelp(UiLabel label, JavaWriter writer, String varName) throws IOException {
        if (label == null) {
            return;
        }
        if (label.getId() == null) {
            writer.code("%s.setHelp(() -> new %s(\"%s\"));", new Object[]{varName, QuickHelp.class.getName(), StringEscapeUtils.escapeJava((String)label.toString())});
        } else {
            writer.beginBlock("%s.setHelp(() -> ", new Object[]{varName});
            writer.code("%s uiLabel = %s.get().getLabels().get(\"%s\");", new Object[]{UiLabel.class.getName(), UiMetaRegistry.class.getName(), label.getId()});
            writer.code("return new %s(uiLabel == null ? \"%s\" : uiLabel.toString());", new Object[]{QuickHelp.class.getName(), varName, label.getId()});
            writer.endBlock(");");
        }
    }

    static void generateProperties(JavaWriter writer, List<UiModel.Field> properties) throws IOException {
        for (UiModel.Field prop : properties) {
            if (!prop.isCollection()) {
                String implType;
                String type;
                switch (prop.getType()) {
                    case "boolean": 
                    case "Boolean": {
                        type = BooleanProperty.class.getName();
                        implType = SimpleBooleanProperty.class.getName();
                        break;
                    }
                    case "double": 
                    case "Double": {
                        type = DoubleProperty.class.getName();
                        implType = SimpleDoubleProperty.class.getName();
                        break;
                    }
                    case "float": 
                    case "Float": {
                        type = FloatProperty.class.getName();
                        implType = SimpleFloatProperty.class.getName();
                        break;
                    }
                    case "int": 
                    case "Integer": {
                        type = IntegerProperty.class.getName();
                        implType = SimpleIntegerProperty.class.getName();
                        break;
                    }
                    case "long": 
                    case "Long": {
                        type = LongProperty.class.getName();
                        implType = SimpleLongProperty.class.getName();
                        break;
                    }
                    case "String": {
                        type = StringProperty.class.getName();
                        implType = SimpleStringProperty.class.getName();
                        break;
                    }
                    default: {
                        type = ObjectProperty.class.getName() + '<' + prop.getType() + '>';
                        implType = SimpleObjectProperty.class.getName() + "<>";
                    }
                }
                writer.code("private final %s %sProp = new %s();", new Object[]{type, prop.getId(), implType});
                writer.blank();
                writer.beginBlock("public final %s %sProperty()", new Object[]{type, prop.getId()});
                writer.code("return %sProp;", new Object[]{prop.getId()});
                writer.endBlock();
                continue;
            }
            writer.code("private final %s<%s> %sProp = %s.observableArrayList();", new Object[]{ObservableList.class.getName(), prop.getType(), prop.getId(), FXCollections.class.getName()});
            writer.blank();
            writer.beginBlock("public final %s<%s> %sProperty()", new Object[]{ObservableList.class.getName(), prop.getType(), prop.getId()});
            writer.code("return %sProp;", new Object[]{prop.getId()});
            writer.endBlock();
        }
    }

    private CodeGenHelper() {
    }
}

