/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.gen;

import com.gridnine.xtrip.client.fx.core.gen.CodeGenHelper;
import com.gridnine.xtrip.client.fx.core.gen.Widgets;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.ui.BaseUiMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiTile;
import com.gridnine.xtrip.common.meta.ui.UiTilesSpace;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.scene.Node;

final class TilesSpaceGenerator {
    static void generate(JavaWriter writer, GenerationContext ctx, UiTilesSpace space) throws Exception {
        writer.beginCompilationUnit(ctx.getOutFolder(), space.getId());
        writer.doc("Tiles space generated from UI metadata:\n<dl><dt>view ID</dt><dd>%s</dd>\n<dt>model</dt><dd>{@link %s}</dd>\n<dt>controller</dt><dd>{@link %1$sController}</dd>\n<dt>sources</dt><dd>%s</dd></dl>", new Object[]{space.getId(), space.getModel().getClassName(), ctx.getUiMetaRegistry().getSources((BaseUiMetaElement)space).stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>"))});
        if (space.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public class %s extends %s", new Object[]{GenUtil.getSimpleClassName((String)space.getId()), TilesSpace.class.getName()});
        TilesSpaceGenerator.generateConstructor(writer, ctx, space);
        CodeGenHelper.generateProperties(writer, space.getProperties());
        TilesSpaceGenerator.generateFields(writer, ctx, space);
        TilesSpaceGenerator.generateMethods(writer, ctx, space);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private static void generateFields(JavaWriter writer, GenerationContext ctx, UiTilesSpace space) throws Exception {
        if (space.getOverview() != null) {
            UiElement overview = space.getOverview();
            String overviewType = overview instanceof UiContainerReference ? ((UiContainerReference)overview).getId() : Widgets.getFor((BaseUiWidget)overview).getWidgetClass(ctx, (BaseUiWidget)overview);
            writer.code("private final %s overviewNode;", new Object[]{overviewType});
            writer.beginBlock("public %s getOverviewNode()", new Object[]{overviewType});
            writer.code("return overviewNode;", new Object[0]);
            writer.endBlock();
        }
        for (UiTile tile : space.getTiles()) {
            String fullType;
            String compactType;
            if (tile.getCompactPayload() != null) {
                UiElement payload = tile.getCompactPayload();
                if (payload instanceof UiContainerReference) {
                    UiContainerReference ref = (UiContainerReference)payload;
                    compactType = ref.getId();
                } else {
                    Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                    compactType = widget.getWidgetClass(ctx, (BaseUiWidget)payload);
                }
            } else {
                compactType = Node.class.getName();
            }
            if (tile.getFullPayload() != null) {
                UiElement payload = tile.getFullPayload();
                if (payload instanceof UiContainerReference) {
                    UiContainerReference ref = (UiContainerReference)payload;
                    fullType = ref.getId();
                } else {
                    Widgets widget = Widgets.getFor((BaseUiWidget)payload);
                    fullType = widget.getWidgetClass(ctx, (BaseUiWidget)payload);
                }
            } else {
                fullType = Node.class.getName();
            }
            String tileType = String.format("%s<%s, %s>", Tile.class.getName(), compactType, fullType);
            writer.code("private final %s %sTile;", new Object[]{tileType, tile.getId()});
            writer.beginBlock("public %s get%sTile()", new Object[]{tileType, GenUtil.capitalize((String)tile.getId())});
            writer.code("return %sTile;", new Object[]{tile.getId()});
            writer.endBlock();
            if (tile.getCompactPayload() != null) {
                writer.beginBlock("%s get%sCompactNode()", new Object[]{compactType, GenUtil.capitalize((String)tile.getId())});
                writer.code("return %sTile.getCompactNode();", new Object[]{tile.getId()});
                writer.endBlock();
            }
            if (tile.getFullPayload() != null) {
                writer.beginBlock("%s get%sFullNode()", new Object[]{fullType, GenUtil.capitalize((String)tile.getId())});
                writer.code("return %sTile.getFullNode();", new Object[]{tile.getId()});
                writer.endBlock();
            }
            writer.blank();
        }
    }

    private static void generateMethods(JavaWriter writer, GenerationContext ctx, UiTilesSpace space) throws Exception {
    }

    private static void generateConstructor(JavaWriter writer, GenerationContext ctx, UiTilesSpace space) throws Exception {
        writer.beginBlock("public %s(boolean readonly)", new Object[]{GenUtil.getSimpleClassName((String)space.getId())});
        writer.code("super(%s);", new Object[]{space.getColumns()});
        if (space.getOverview() != null) {
            UiElement overview = space.getOverview();
            if (overview instanceof UiContainerReference) {
                writer.code("overviewNode = new %s(readonly);", new Object[]{((UiContainerReference)overview).getId()});
            } else {
                Widgets.getFor((BaseUiWidget)overview).generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)overview, "overview");
            }
        }
        writer.code("%s<%s<?, ?>> tiles = new %1$s<>();", new Object[]{ArrayList.class.getName(), Tile.class.getName()});
        for (UiTile tile : space.getTiles()) {
            Widgets widget;
            UiContainerReference ref;
            UiElement payload;
            writer.beginBlock();
            CodeGenHelper.genLabelVar(tile.getCaption(), writer, "tileCaption");
            if (tile.getCompactPayload() != null) {
                payload = tile.getCompactPayload();
                if (payload instanceof UiContainerReference) {
                    ref = (UiContainerReference)payload;
                    writer.code("%s compactNode = new %1$s(readonly);", new Object[]{ref.getId()});
                } else {
                    widget = Widgets.getFor((BaseUiWidget)payload);
                    writer.code("%s compactNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
                    widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "compact");
                }
            } else {
                writer.code("%s compactNode = null;", new Object[]{Node.class.getName()});
            }
            if (tile.getFullPayload() != null) {
                payload = tile.getFullPayload();
                if (payload instanceof UiContainerReference) {
                    ref = (UiContainerReference)payload;
                    writer.code("%s fullNode = new %1$s(readonly);", new Object[]{ref.getId()});
                } else {
                    widget = Widgets.getFor((BaseUiWidget)payload);
                    writer.code("%s fullNode;", new Object[]{widget.getWidgetClass(ctx, (BaseUiWidget)payload)});
                    widget.generateContainerFieldInitializer(writer, ctx, (BaseUiWidget)payload, "full");
                }
            } else {
                writer.code("%s fullNode = null;", new Object[]{Node.class.getName()});
            }
            writer.code("%sTile = new %s<>(\"%1$s\", tileCaption, compactNode, fullNode);", new Object[]{tile.getId(), Tile.class.getName()});
            CodeGenHelper.genSetHelp(tile.getHelp(), writer, tile.getId() + "Tile");
            writer.code("tiles.add(%sTile);", new Object[]{tile.getId()});
            writer.endBlock();
        }
        if (space.getOverview() != null) {
            writer.code("setOverview(overviewNode);", new Object[0]);
        }
        writer.code("addTiles(tiles);", new Object[0]);
        writer.endBlock();
    }

    private TilesSpaceGenerator() {
    }
}

