/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import org.w3c.dom.Document;

public class BrowserPane
extends BorderPane {
    private Button nextButton;
    private Button previousButton;
    protected WebView webView;
    private Button newWindowButton;
    private Button reloadButton;
    private TextField urlField;
    private final ObservableMutex mutex;

    public BrowserPane(ObservableMutex mtx) {
        this.mutex = mtx;
        this.createUI();
        this.initialize();
    }

    private void createUI() {
        this.getStyleClass().add((Object)"xtrip-browser-pane");
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"tools-pane");
        RowConstraints rc = new RowConstraints();
        rc.setValignment(VPos.CENTER);
        gridPane.getRowConstraints().add((Object)rc);
        BorderPane.setAlignment((Node)gridPane, (Pos)Pos.CENTER);
        this.previousButton = new Button();
        this.previousButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_PREV_14x14, (Styleable)this.previousButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.previousButton));
        this.previousButton.getStyleClass().add((Object)"xtrip-button");
        GridPane.setColumnIndex((Node)this.previousButton, (Integer)gridPane.getChildren().size());
        GridPane.setHgrow((Node)this.previousButton, (Priority)Priority.NEVER);
        gridPane.getChildren().add((Object)this.previousButton);
        this.nextButton = new Button();
        this.nextButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_NEXT_14x14, (Styleable)this.nextButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.nextButton));
        this.nextButton.getStyleClass().add((Object)"xtrip-button");
        GridPane.setColumnIndex((Node)this.nextButton, (Integer)gridPane.getChildren().size());
        GridPane.setHgrow((Node)this.nextButton, (Priority)Priority.NEVER);
        gridPane.getChildren().add((Object)this.nextButton);
        this.reloadButton = new Button();
        this.reloadButton.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)this.reloadButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.reloadButton));
        this.reloadButton.getStyleClass().add((Object)"xtrip-button");
        GridPane.setColumnIndex((Node)this.reloadButton, (Integer)gridPane.getChildren().size());
        GridPane.setHgrow((Node)this.reloadButton, (Priority)Priority.NEVER);
        gridPane.getChildren().add((Object)this.reloadButton);
        this.urlField = new CustomTextField();
        GridPane.setColumnIndex((Node)this.urlField, (Integer)gridPane.getChildren().size());
        GridPane.setHgrow((Node)this.urlField, (Priority)Priority.ALWAYS);
        gridPane.getChildren().add((Object)this.urlField);
        this.newWindowButton = new Button();
        this.newWindowButton.setGraphic((Node)new IconNode(StandardIconShapes.BROWSER_LINK_12x12, (Styleable)this.newWindowButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.newWindowButton));
        this.newWindowButton.getStyleClass().add((Object)"xtrip-button");
        GridPane.setColumnIndex((Node)this.newWindowButton, (Integer)gridPane.getChildren().size());
        GridPane.setHgrow((Node)this.newWindowButton, (Priority)Priority.NEVER);
        gridPane.getChildren().add((Object)this.newWindowButton);
        this.setTop((Node)gridPane);
        this.webView = new WebView();
        this.webView.setContextMenuEnabled(false);
        BorderPane.setAlignment((Node)this.webView, (Pos)Pos.CENTER);
        this.setCenter((Node)this.webView);
    }

    private void initialize() {
        this.webView.getEngine().locationProperty().addListener((obj, oldValue, newValue) -> this.urlField.setText(newValue));
        this.webView.getEngine().getLoadWorker().stateProperty().addListener((obj, oldValue, newValue) -> {
            switch (newValue) {
                case RUNNING: 
                case SCHEDULED: {
                    if (this.mutex.isAcquired()) break;
                    try {
                        this.mutex.acquire();
                        break;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                default: {
                    this.mutex.release();
                }
            }
        });
        this.reloadButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        this.reloadButton.setOnAction(event -> this.webView.getEngine().reload());
        this.urlField.setOnAction(event -> this.navigateTo(this.urlField.getText()));
        this.newWindowButton.setOnAction(event -> {
            String url = this.urlField.getText();
            if (TextUtil.isBlank((String)url)) {
                return;
            }
            FxUtil.openUrl(url);
        });
        this.previousButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                WebHistory history = BrowserPane.this.webView.getEngine().getHistory();
                this.bind(new Observable[]{history.currentIndexProperty(), history.getEntries()});
            }

            protected boolean computeValue() {
                return BrowserPane.this.webView.getEngine().getHistory().getCurrentIndex() <= 0;
            }
        });
        this.previousButton.setOnAction(event -> this.webView.getEngine().getHistory().go(-1));
        this.nextButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                WebHistory history = BrowserPane.this.webView.getEngine().getHistory();
                this.bind(new Observable[]{history.currentIndexProperty(), history.getEntries()});
            }

            protected boolean computeValue() {
                WebHistory history = BrowserPane.this.webView.getEngine().getHistory();
                return history.getCurrentIndex() >= history.getEntries().size() - 1;
            }
        });
        this.nextButton.setOnAction(event -> this.webView.getEngine().getHistory().go(1));
    }

    public void navigateTo(String url) {
        if (TextUtil.isBlank((String)url)) {
            return;
        }
        int p = url.indexOf("://");
        this.webView.getEngine().load((p == -1 || p > 10 ? "http://" : "") + url);
    }

    public ReadOnlyProperty<String> titleProperty() {
        return this.webView.getEngine().titleProperty();
    }

    public ReadOnlyProperty<Document> documentProperty() {
        return this.webView.getEngine().documentProperty();
    }

    public void dispose() {
        this.webView.getEngine().getLoadWorker().cancel();
    }
}

