/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Region;

public final class Buttons {
    public static Region clearButton(Runnable action) {
        IconNode result = new IconNode(StandardIconShapes.CLEAR, null, StandardIconIntentions.CLEAR_BUTTON_ACTION, null);
        result.getStyleClass().add((Object)"clear-button");
        result.setOnMouseReleased(evt -> {
            if (evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                evt.consume();
                action.run();
            }
        });
        UiUtil.setTooltip((Node)result, Messages.General_Clean);
        return result;
    }

    public static Region expandButton(Runnable action) {
        IconNode result = new IconNode(StandardIconShapes.EXPAND, null, StandardIconIntentions.CLEAR_BUTTON_ACTION, null);
        result.getStyleClass().add((Object)"expand-button");
        result.setOnMouseReleased(evt -> {
            if (evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                evt.consume();
                action.run();
            }
        });
        UiUtil.setTooltip((Node)result, Messages.General_Expand);
        return result;
    }

    public static Region quickHelpButton(Supplier<QuickHelp> help) {
        IconNode result = new IconNode(StandardIconShapes.TOOLTIP_12x12, null, StandardIconIntentions.TOOLTIP_ACTION, null);
        result.getStyleClass().add((Object)"tooltip-icon");
        result.setOnMouseReleased(evt -> {
            evt.consume();
            QuickHelp.show((QuickHelp)help.get(), (Region)result);
        });
        return result;
    }

    private Buttons() {
    }
}

