/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.PopupWindow;

class CustomComboBoxSkin<T>
extends ComboBoxListViewSkin<T> {
    final CustomComboBox<T> widget;
    private final SimpleBooleanProperty clearButtonVisible = new SimpleBooleanProperty();
    private Region clearButton;
    private Tooltip clearButtonTT;
    private Tooltip arrowButtonTT;

    CustomComboBoxSkin(final CustomComboBox<T> w) {
        super(w);
        this.widget = w;
        this.clearButtonVisible.bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{w.hoverProperty()});
            }

            protected boolean computeValue() {
                return !CustomComboBoxSkin.this.widget.noNulls && w.getValue() != null && w.isHover();
            }
        });
        this.clearButtonVisible.addListener((s, o, n) -> this.updateClearButton());
        if (this.widget.buttonStyle == CustomComboBox.ButtonStyle.HIDDEN) {
            try {
                Method method = null;
                for (Method mthd : ComboBoxBaseSkin.class.getDeclaredMethods()) {
                    if (!"setMode".equals(mthd.getName())) continue;
                    method = mthd;
                    break;
                }
                if (method != null) {
                    method.invoke((Object)this, Class.forName("com.sun.javafx.scene.control.skin.ComboBoxMode").getEnumConstants()[2]);
                }
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        } else {
            this.arrowButton.getChildren().setAll((Object[])new Node[]{new IconNode(this.widget.buttonStyle.getIconShape(), (Styleable)w, StandardIconIntentions.COMBOBOX_LIST_ARROW_ACTION, (Styleable)w)});
            this.updateTooltips();
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
                if (!evt.isAltDown() || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                Function<Object, String> mapper = evt.isShiftDown() || w.getConverter() == null ? Object::toString : item -> w.getConverter().toString(item);
                String text = this.getListView().getItems().stream().map(mapper).collect(Collectors.joining("\n"));
                Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, text));
                UiUtil.showPopup((PopupWindow)UiUtil.createPopup((Parent)new Label(evt.isShiftDown() ? Messages.Combobox_Copy_Hint_1 : Messages.Combobox_Copy_Hint_2)), (Region)this.arrowButton);
            });
        }
    }

    private void updateClearButton() {
        if (!this.clearButtonVisible.get() && this.clearButton != null) {
            this.getChildren().remove((Object)this.clearButton);
            this.clearButton = null;
            this.clearButtonTT = null;
            return;
        }
        if (this.clearButton != null) {
            return;
        }
        this.clearButton = Buttons.clearButton(this.widget.clearAction::run);
        this.clearButton.setManaged(false);
        this.getChildren().add((Object)this.clearButton);
        this.updateTooltips();
    }

    void updateTooltips() {
        if (this.arrowButtonTT == null) {
            this.arrowButtonTT = new Tooltip(Messages.General_Choose_value_from_list);
            Tooltip.install((Node)this.arrowButton, (Tooltip)this.arrowButtonTT);
        }
        if (this.clearButtonTT == null && this.clearButton != null) {
            this.clearButtonTT = new Tooltip(this.widget.clearButtonTooltip);
            Tooltip.install((Node)this.clearButton, (Tooltip)this.clearButtonTT);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.clearButton == null) {
            return;
        }
        double arrowButtonWidth = this.arrowButton.snappedLeftInset() + this.snapSize(this.arrow.prefWidth(-1.0)) + this.arrowButton.snappedRightInset();
        double clearButtonWidth = this.clearButton.snappedLeftInset() + this.snapSize(this.clearButton.prefWidth(-1.0)) + this.clearButton.snappedRightInset();
        this.positionInArea((Node)this.clearButton, x + w - arrowButtonWidth - clearButtonWidth, y, clearButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected void setTextFromTextFieldIntoComboBoxValue() {
    }
}

