/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.text.HitInfo;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;

class CustomTextFieldSkin
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass((String)"no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass((String)"left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass((String)"right-node-visible");
    private StackPane leftPane;
    private StackPane rightPane;
    private AnchorPane anchor;

    CustomTextFieldSkin(CustomTextField textField) {
        super((TextField)textField, new TextFieldBehavior((TextField)textField));
        this.updateChildren();
        this.registerChangeListener((ObservableValue)textField.leftProperty(), "LEFT_NODE");
        this.registerChangeListener((ObservableValue)textField.rightProperty(), "RIGHT_NODE");
        this.registerChangeListener((ObservableValue)textField.focusedProperty(), "FOCUSED");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        switch (p) {
            case "LEFT_NODE": 
            case "RIGHT_NODE": {
                this.updateChildren();
                break;
            }
        }
    }

    private void updateChildren() {
        CustomTextField textField = (CustomTextField)this.getSkinnable();
        Node left = (Node)textField.leftProperty().get();
        Node right = (Node)textField.rightProperty().get();
        if ((left != null || right != null) && this.anchor == null) {
            this.anchor = new AnchorPane();
            this.getChildren().add((Object)this.anchor);
        }
        if (left != null) {
            if (this.leftPane == null) {
                this.leftPane = new StackPane(new Node[]{left});
                this.leftPane.setAlignment(Pos.CENTER_LEFT);
                this.leftPane.getStyleClass().add((Object)"left-pane");
                AnchorPane.setTopAnchor((Node)this.leftPane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)this.leftPane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.leftPane, (Double)0.0);
                this.anchor.getChildren().add((Object)this.leftPane);
            } else {
                this.leftPane.getChildren().setAll((Object[])new Node[]{left});
            }
        } else if (this.leftPane != null) {
            this.leftPane.getChildren().clear();
        }
        if (right != null) {
            if (this.rightPane == null) {
                this.rightPane = new StackPane(new Node[]{right});
                this.rightPane.setAlignment(Pos.CENTER_RIGHT);
                this.rightPane.getStyleClass().add((Object)"right-pane");
                AnchorPane.setTopAnchor((Node)this.rightPane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)this.rightPane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.rightPane, (Double)0.0);
                this.anchor.getChildren().add((Object)this.rightPane);
            } else {
                this.rightPane.getChildren().setAll((Object[])new Node[]{right});
            }
        } else if (this.rightPane != null) {
            this.rightPane.getChildren().clear();
        }
        ((TextField)this.getSkinnable()).pseudoClassStateChanged(HAS_LEFT_NODE, left != null);
        ((TextField)this.getSkinnable()).pseudoClassStateChanged(HAS_RIGHT_NODE, right != null);
        ((TextField)this.getSkinnable()).pseudoClassStateChanged(HAS_NO_SIDE_NODE, left == null && right == null);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double fullHeight = h + this.snappedTopInset() + this.snappedBottomInset();
        double fullWidth = w + this.snappedLeftInset() + this.snappedRightInset();
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(fullHeight));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(fullHeight));
        double textFieldStartX = this.snapPosition(x) + this.snapSize(leftWidth);
        double textFieldWidth = w - this.snapSize(leftWidth) - this.snapSize(rightWidth);
        super.layoutChildren(textFieldStartX, 0.0, textFieldWidth, fullHeight);
        if (this.anchor != null) {
            this.anchor.relocate(0.0, 0.0);
            this.anchor.resize(fullWidth, fullHeight);
        }
    }

    public HitInfo getIndex(double x, double y) {
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(((TextField)this.getSkinnable()).getHeight()));
        return super.getIndex(x - leftWidth, y);
    }

    protected double computePrefWidth(double h, double topInset, double rightInset, double bottomInset, double leftInset) {
        double rightWidth;
        Bounds bounds = UiUtil.computeTextBounds((TextField)this.getSkinnable());
        double pw = Math.ceil(bounds.getWidth());
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(h));
        double d = rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(h));
        return ((TextField)this.getSkinnable()).isEditable() ? pw + leftWidth + leftInset + (rightInset == 0.0 ? leftInset : rightInset) : pw + leftWidth + leftInset + rightWidth + rightInset;
    }

    protected double computePrefHeight(double w, double topInset, double rightInset, double bottomInset, double leftInset) {
        double ph = super.computePrefHeight(w, topInset, rightInset, bottomInset, leftInset);
        double leftHeight = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefHeight(-1.0));
        double rightHeight = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefHeight(-1.0));
        return Math.max(ph, Math.max(leftHeight, rightHeight));
    }
}

