/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class FilteringPane<N extends Node>
extends StackPane {
    private final Supplier<N> supplier;
    private final Label captionLabelNode = new Label();
    private final TitledPane titledPane;
    private final StaticPane<N> staticPane;
    private Consumer<N> onApply;
    private ObservableMutex mutex;
    private Button clearButton;
    private Button applyButton;

    public FilteringPane(Supplier<N> filtersPaneSupplier, boolean collapsible) {
        this.supplier = filtersPaneSupplier;
        if (collapsible) {
            this.titledPane = new TitledPane();
            this.titledPane.getStyleClass().addAll((Object[])new String[]{"xtrip-filters-pane", "embedded"});
            this.captionLabelNode.getStyleClass().add((Object)"xtrip-underline");
            this.titledPane.setContent((Node)this.supplier.get());
            Button ruler = new Button();
            Button filter = new Button();
            HBox titleLabelPane = new HBox(new Node[]{filter, this.captionLabelNode, ruler});
            AnchorPane titleParentPane = new AnchorPane(new Node[]{titleLabelPane});
            ruler.setGraphic((Node)new IconNode(StandardIconShapes.RULER_14X14, (Styleable)titleParentPane, StandardIconIntentions.RULER_BUTTON_ACTION, (Styleable)titleParentPane));
            ruler.getStyleClass().add((Object)"ruler");
            ruler.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> this.setExpanded(!this.titledPane.isExpanded()));
            filter.setGraphic((Node)new IconNode(StandardIconShapes.LIST_FILTER_12x12, (Styleable)titleParentPane, StandardIconIntentions.RULER_BUTTON_ACTION, (Styleable)titleParentPane));
            filter.getStyleClass().add((Object)"filter");
            filter.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> this.setExpanded(!this.titledPane.isExpanded()));
            titleLabelPane.getStyleClass().add((Object)"title-label-pane");
            titleParentPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
            AnchorPane.setLeftAnchor((Node)titleLabelPane, (Double)Double.MIN_VALUE);
            this.titledPane.setGraphic((Node)titleParentPane);
            this.titledPane.expandedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$2((Pane)titleParentPane, (Pane)titleLabelPane, arg_0, arg_1, arg_2));
            this.titledPane.setExpanded(true);
            titleParentPane.getChildren().add((Object)this.createButtonsPane());
            this.getChildren().add((Object)this.titledPane);
            this.staticPane = null;
        } else {
            this.staticPane = new StaticPane<Node>((Node)this.supplier.get(), this.createButtonsPane());
            this.getChildren().add(this.staticPane);
            this.titledPane = null;
        }
    }

    public N getContent() {
        if (this.titledPane != null) {
            return (N)this.titledPane.getContent();
        }
        return this.staticPane.getContent();
    }

    public void setCaption(String labelText) {
        this.captionLabelNode.setText(labelText);
    }

    public void setOnApply(Consumer<N> value) {
        this.onApply = value;
    }

    public void setMutex(ObservableMutex value) {
        if (this.mutex != null) {
            if (this.clearButton != null) {
                this.clearButton.disableProperty().unbind();
            }
            if (this.applyButton != null) {
                this.applyButton.disableProperty().unbind();
            }
        }
        this.mutex = value;
        if (this.mutex != null) {
            if (this.clearButton != null) {
                this.clearButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
            }
            if (this.applyButton != null) {
                this.applyButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
            }
        }
    }

    public void apply() {
        if (this.onApply != null) {
            this.onApply.accept(this.getContent());
        }
    }

    public void reset() {
        if (this.titledPane != null) {
            this.titledPane.setContent((Node)this.supplier.get());
        } else {
            this.staticPane.setContent((Node)this.supplier.get());
        }
        if (this.onApply != null) {
            this.onApply.accept(this.getContent());
        }
    }

    private Pane createButtonsPane() {
        this.clearButton = new Button(Messages.General_Reset);
        this.clearButton.getStyleClass().add((Object)"reset-button");
        this.clearButton.setCancelButton(true);
        this.clearButton.setOnAction(evt -> this.reset());
        this.applyButton = new Button(Messages.General_Apply);
        this.applyButton.getStyleClass().add((Object)"apply-button");
        this.applyButton.setDefaultButton(true);
        this.applyButton.setOnAction(evt -> this.apply());
        if (this.mutex != null) {
            this.clearButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
            this.applyButton.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        }
        HBox result = new HBox(new Node[]{this.clearButton, this.applyButton});
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setAlignment(Pos.CENTER_RIGHT);
        result.getStyleClass().add((Object)"buttons-pane");
        AnchorPane.setRightAnchor((Node)result, (Double)Double.MIN_VALUE);
        return result;
    }

    public void setExpanded(boolean value) {
        if (this.titledPane != null) {
            this.titledPane.setExpanded(value);
        }
    }

    private /* synthetic */ void lambda$new$2(Pane titleParentPane, Pane titleLabelPane, ObservableValue s, Boolean o, Boolean n) {
        if (!n.booleanValue()) {
            if (titleParentPane.getChildren().size() > 1) {
                titleParentPane.getChildren().setAll((Object[])new Node[]{titleLabelPane});
            }
        } else if (titleParentPane.getChildren().size() == 1) {
            titleParentPane.getChildren().add((Object)this.createButtonsPane());
        }
    }

    private static class StaticPane<N extends Node>
    extends HBox {
        StaticPane(N content, Pane buttonsPane) {
            super(new Node[]{content, buttonsPane});
            this.getStyleClass().addAll((Object[])new String[]{"xtrip-filters-pane", "static", "embedded"});
            HBox.setHgrow(content, (Priority)Priority.ALWAYS);
        }

        N getContent() {
            return (N)((Node)this.getChildren().get(0));
        }

        void setContent(N value) {
            this.getChildren().set(0, value);
            HBox.setHgrow(value, (Priority)Priority.ALWAYS);
        }
    }
}

