/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class MessagePane
extends HBox {
    private final MessageType type;

    public static MessagePane forMessage(Message message) {
        return new MessagePane(message.getType() == null ? MessageType.WARNING : message.getType(), message.getMessage() == null ? message.toString() : message.getMessage().toString(), message.getDetails());
    }

    public static MessagePane info(String message) {
        return new MessagePane(MessageType.MESSAGE, message, null);
    }

    public static MessagePane info(String message, String details) {
        return new MessagePane(MessageType.MESSAGE, message, details);
    }

    public static MessagePane warning(String message) {
        return new MessagePane(MessageType.WARNING, message, null);
    }

    public static MessagePane warning(String message, String details) {
        return new MessagePane(MessageType.WARNING, message, details);
    }

    public static MessagePane error(String message) {
        return new MessagePane(MessageType.ERROR, message, null);
    }

    public static MessagePane error(String message, String details) {
        return new MessagePane(MessageType.ERROR, message, details);
    }

    public static MessagePane error(Throwable error) {
        return new MessagePane(MessageType.ERROR, ErrorHandler.getMessage(error), error.toString());
    }

    protected MessagePane(MessageType type, String message, String details) {
        IconNode icon;
        String typeClass;
        this.type = type;
        switch (type) {
            case ERROR: {
                typeClass = "error";
                icon = new IconNode(StandardIconShapes.VALIDATOR_ERROR, null, StandardIconIntentions.VALIDATOR_ERROR, null);
                break;
            }
            case FOR_USER: 
            case MESSAGE: {
                typeClass = "info";
                icon = new IconNode(StandardIconShapes.VALIDATOR_MESSAGE, null, StandardIconIntentions.VALIDATOR_MESSAGE, null);
                break;
            }
            case WARNING: {
                typeClass = "warning";
                icon = new IconNode(StandardIconShapes.VALIDATOR_WARNING, null, StandardIconIntentions.VALIDATOR_WARNING, null);
                break;
            }
            default: {
                typeClass = "warning";
                icon = new IconNode(StandardIconShapes.VALIDATOR_WARNING, null, StandardIconIntentions.VALIDATOR_WARNING, null);
            }
        }
        this.getStyleClass().addAll((Object[])new String[]{"message-pane", typeClass});
        CustomLabel text = new CustomLabel(message);
        this.getChildren().add((Object)text);
        text.setGraphic((Node)icon);
        if (details != null) {
            HyperlinkWidget detailsLink = new HyperlinkWidget();
            detailsLink.setText(Messages.General_Details);
            detailsLink.setOnAction(event -> Dialog.message((Node)this, Messages.General_Details, details));
            StackPane sp = new StackPane(new Node[]{detailsLink});
            sp.setAlignment(Pos.CENTER_LEFT);
            this.getChildren().add((Object)sp);
            HBox.setHgrow((Node)sp, (Priority)Priority.ALWAYS);
        } else {
            HBox.setHgrow((Node)text, (Priority)Priority.ALWAYS);
        }
    }

    public MessagePane makeClosable(Runnable callback) {
        IconNode clearButton;
        switch (this.type) {
            case ERROR: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_ERROR, null);
                break;
            }
            case FOR_USER: 
            case MESSAGE: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_MESSAGE, null);
                break;
            }
            case WARNING: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_WARNING, null);
                break;
            }
            default: {
                clearButton = new IconNode(StandardIconShapes.CLOSE_14X14, null, StandardIconIntentions.VALIDATOR_CLEAR_BUTTON_WARNING, null);
            }
        }
        clearButton.getStyleClass().addAll((Object[])new String[]{"clear-button"});
        Tooltip.install((Node)clearButton, (Tooltip)new Tooltip(Messages.General_Delete_message));
        clearButton.setOnMouseReleased(event -> {
            event.consume();
            callback.run();
        });
        HBox.setHgrow((Node)clearButton, (Priority)Priority.NEVER);
        this.getChildren().add((Object)clearButton);
        return this;
    }

    public MessagePane setWrapText(boolean wrapText) {
        if (!this.getChildren().isEmpty()) {
            ((Label)this.getChildren().get(0)).setWrapText(wrapText);
        }
        return this;
    }
}

