/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.menu;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.scene.Parent;

public class CustomCheckMenuItem
extends CustomMenuItem {
    private static final String DEFAULT_STYLE_CLASS = "xtrip-custom-check-menu-item";
    private static final String STYLE_CLASS_CHECKED = "checked";
    private static final PseudoClass CHECKED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"checked");
    private ObjectProperty<IconShape> checkShape;
    private BooleanProperty checked;

    public CustomCheckMenuItem() {
        this(StandardIconShapes.CHECK_14X14, null, null);
    }

    public CustomCheckMenuItem(IconShape checkShape) {
        this(checkShape, null, null);
    }

    public CustomCheckMenuItem(String title) {
        this(StandardIconShapes.CHECK_14X14, null, title);
    }

    public CustomCheckMenuItem(IconShape checkShape, String title) {
        this(checkShape, null, title);
    }

    public CustomCheckMenuItem(IconShape checkShape, IconShape shape, String title) {
        super(shape, title);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setHideOnClick(false);
        this.setCheckShape(checkShape);
    }

    public final void setCheckShape(IconShape value) {
        this.checkShapeProperty().set((Object)value);
    }

    public final IconShape getCheckShape() {
        return this.checkShape != null ? (IconShape)this.checkShape.get() : null;
    }

    public final ObjectProperty<IconShape> checkShapeProperty() {
        if (this.checkShape == null) {
            this.checkShape = new SimpleObjectProperty((Object)this, "checkShape");
        }
        return this.checkShape;
    }

    public final void setChecked(boolean value) {
        this.checkedProperty().set(value);
    }

    public final boolean isChecked() {
        return this.checked != null ? this.checked.get() : false;
    }

    public final BooleanProperty checkedProperty() {
        if (this.checked == null) {
            this.checked = new BooleanPropertyBase(){

                protected void invalidated() {
                    this.get();
                    if (CustomCheckMenuItem.this.isChecked()) {
                        CustomCheckMenuItem.this.getStyleClass().add((Object)CustomCheckMenuItem.STYLE_CLASS_CHECKED);
                    } else {
                        CustomCheckMenuItem.this.getStyleClass().remove((Object)CustomCheckMenuItem.STYLE_CLASS_CHECKED);
                    }
                    CustomCheckMenuItem.this.update();
                }

                public Object getBean() {
                    return CustomCheckMenuItem.this;
                }

                public String getName() {
                    return CustomCheckMenuItem.STYLE_CLASS_CHECKED;
                }
            };
        }
        return this.checked;
    }

    @Override
    protected void update() {
        Parent parent;
        super.update();
        for (parent = this.getContent().getParent(); parent != null && !parent.getStyleClass().contains((Object)DEFAULT_STYLE_CLASS); parent = parent.getParent()) {
        }
        if (parent != null) {
            parent.pseudoClassStateChanged(CHECKED_PSEUDOCLASS_STATE, this.isChecked());
        }
    }
}

