/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;

public class SimpleSuggestionsHandler<T>
implements SuggestionsHandler<T> {
    private final StringConverter<T> converter;
    private final Supplier<List<T>> supplier;
    private final boolean sort;
    private boolean async;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[^a-zA-Z\u0430-\u044f\u0410-\u042f_0-9]");

    public SimpleSuggestionsHandler(ComboBox<T> combobox, boolean sort) {
        this(combobox.getConverter(), () -> combobox.getItems(), sort);
    }

    public SimpleSuggestionsHandler(StringConverter<T> converter, Supplier<List<T>> supplier, boolean sort) {
        this.converter = Objects.requireNonNull(converter);
        this.supplier = Objects.requireNonNull(supplier);
        this.sort = sort;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean value) {
        this.async = value;
    }

    @Override
    public void startSession(SuggestionSession<T> session) {
        String text = session.getUserText();
        if (TextUtil.isBlank((String)text)) {
            session.setSuggestions(Collections.emptyList());
            return;
        }
        String pattern = text.trim().toLowerCase(Locale.ROOT);
        Stream<Object> stream = this.supplier.get().stream().filter(item -> {
            String str = this.converter.toString(item);
            if (str == null) {
                return false;
            }
            return this.matches(pattern, str.toLowerCase(Locale.ROOT));
        });
        if (this.sort) {
            stream = stream.sorted((i1, i2) -> TextUtil.compare((String)this.converter.toString(i1), (String)this.converter.toString(i2), (boolean)true, (boolean)false));
        }
        session.setSuggestions(stream.collect(Collectors.toList()));
    }

    private boolean matches(String pattern, String text) {
        if (text.startsWith(pattern)) {
            return true;
        }
        Matcher matcher = SPLIT_PATTERN.matcher(text);
        int pos = 0;
        while (matcher.find(pos)) {
            pos = matcher.end();
            if (!text.startsWith(pattern, pos)) continue;
            return true;
        }
        return false;
    }
}

