/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.suggestions;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.BaseKeyHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsPopup;
import java.util.List;
import javafx.scene.control.ComboBox;

class SyncKeyHandler<T>
extends BaseKeyHandler<T> {
    protected final ComboBox<T> comboBox;
    protected final SuggestionsHandler<T> suggestionsHandler;

    SyncKeyHandler(ComboBox<T> cb, SuggestionsHandler<T> handler) {
        super(cb.getEditor());
        this.comboBox = cb;
        this.suggestionsHandler = handler;
    }

    @Override
    protected void initiateSession() {
        this.suggestionsHandler.startSession(new SuggestionSession<T>(){

            @Override
            public String getUserText() {
                return SyncKeyHandler.this.editor.getText();
            }

            @Override
            public void setSuggestions(List<T> items) {
                if (items.isEmpty()) {
                    if (SyncKeyHandler.this.popup != null) {
                        SyncKeyHandler.this.popup.hide();
                    }
                    return;
                }
                SyncKeyHandler.this.comboBox.hide();
                if (items.size() == 1) {
                    if (SyncKeyHandler.this.popup != null) {
                        SyncKeyHandler.this.popup.hide();
                    }
                    Object value = items.get(0);
                    SyncKeyHandler.this.editor.setText(SyncKeyHandler.this.comboBox.getConverter().toString(value));
                    SyncKeyHandler.this.comboBox.setValue(value);
                    SyncKeyHandler.this.comboBox.getEditor().positionCaret(SyncKeyHandler.this.comboBox.getEditor().getText().length());
                    SyncKeyHandler.this.suggestionsHandler.onSuggestionSelected(value);
                    return;
                }
                if (SyncKeyHandler.this.popup == null) {
                    SyncKeyHandler.this.popup = new SuggestionsPopup(SyncKeyHandler.this.comboBox, SyncKeyHandler.this.suggestionsHandler);
                }
                SyncKeyHandler.this.popup.setSuggestions(items);
            }
        });
    }
}

