/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.components.tree;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.FilterableCheckBoxTreeItem;
import java.util.Collections;
import java.util.Comparator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;

public class SortableCheckBoxTreeItem<V>
extends FilterableCheckBoxTreeItem<V> {
    private final ObjectProperty<Comparator<TreeItem<V>>> comparator = new SimpleObjectProperty();

    public SortableCheckBoxTreeItem() {
        this(null, null, false, false);
    }

    public SortableCheckBoxTreeItem(V value) {
        this(value, (Node)null, false, false);
    }

    public SortableCheckBoxTreeItem(V value, Node graphic) {
        this(value, graphic, false, false);
    }

    public SortableCheckBoxTreeItem(V value, Node graphic, boolean selected) {
        this(value, graphic, selected, false);
    }

    public SortableCheckBoxTreeItem(V value, Node graphic, boolean selected, boolean independent) {
        super(value, graphic);
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue instanceof SortableCheckBoxTreeItem && this.getComparator() == null) {
                this.comparatorProperty().bind(((SortableCheckBoxTreeItem)((Object)newValue)).comparatorProperty());
            }
        });
    }

    public final ObjectProperty<Comparator<TreeItem<V>>> comparatorProperty() {
        return this.comparator;
    }

    public final void setComparator(Comparator<TreeItem<V>> value) {
        this.comparator.set(value);
    }

    public final Comparator<TreeItem<V>> getComparator() {
        return (Comparator)this.comparator.get();
    }

    public <T extends TreeItem<V>> void add(T item) {
        if (this.getComparator() != null) {
            int index = Collections.binarySearch(this.getInternalChildren(), item, this.getComparator());
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
            this.getInternalChildren().add(index, item);
        } else {
            this.getInternalChildren().add(item);
        }
    }

    public <T extends TreeItem<V>> boolean remove(T item) {
        return this.getInternalChildren().remove(item);
    }
}

