/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerEventHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class ControllersRegistry {
    private static final Map<String, List<ControllerInterceptor<?, ?>>> INTERCEPTORS = new HashMap();
    private static final Map<ViewController<?, ?>, List<ControllerEventHandler>> HANDLERS = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <M, C extends ViewController<?, M>> void register(ControllerInterceptor<M, C> interceptor) {
        Map<String, List<ControllerInterceptor<?, ?>>> map = INTERCEPTORS;
        synchronized (map) {
            List<ControllerInterceptor<?, ?>> list = INTERCEPTORS.get(interceptor.getControllerClass().getName());
            if (list == null) {
                list = new ArrayList();
                INTERCEPTORS.put(interceptor.getControllerClass().getName(), list);
            }
            list.add(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DevTool> buildDevToolsFor(String controllerClassName) {
        ArrayList interceptors;
        Map<String, List<ControllerInterceptor<?, ?>>> map = INTERCEPTORS;
        synchronized (map) {
            List<ControllerInterceptor<?, ?>> list = INTERCEPTORS.get(controllerClassName);
            if (list == null) {
                return Collections.emptyList();
            }
            interceptors = new ArrayList(list);
        }
        ArrayList<DevTool> result = new ArrayList<DevTool>();
        for (final ControllerInterceptor controllerInterceptor : interceptors) {
            result.add(new DevTool(){

                @Override
                public DevToolItem asDevToolItem() {
                    return new DevToolItem(){

                        @Override
                        public Collection<?> getSubItems() {
                            return Collections.emptyList();
                        }

                        @Override
                        public String getInfo() {
                            return "I " + MiscUtil.getSimpleClassName(controllerInterceptor.getClass());
                        }
                    };
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(ViewController<?, ?> controller, ControllerEventHandler handler) {
        Map<ViewController<?, ?>, List<ControllerEventHandler>> map = HANDLERS;
        synchronized (map) {
            List<ControllerEventHandler> list = HANDLERS.get(controller);
            if (list == null) {
                list = new ArrayList<ControllerEventHandler>();
                HANDLERS.put(controller, list);
            }
            list.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(ViewController<?, ?> controller, ControllerEventHandler handler) {
        Map<ViewController<?, ?>, List<ControllerEventHandler>> map = HANDLERS;
        synchronized (map) {
            List<ControllerEventHandler> list = HANDLERS.get(controller);
            if (list != null) {
                list.remove(handler);
                if (list.isEmpty()) {
                    HANDLERS.remove(controller);
                }
            }
        }
    }

    public static <M, C extends ViewController<?, M>> void onCreate(C controller) {
        ControllersRegistry.process(controller, null, interceptor -> interceptor.onCreate(controller));
    }

    public static <M, C extends ViewController<?, M>> void beforeReadData(C controller, M model) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.BEFORE_READ_DATA, interceptor -> interceptor.beforeReadData(controller, model));
    }

    public static <M, C extends ViewController<?, M>> void afterReadData(C controller, M model) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.AFTER_READ_DATA, interceptor -> interceptor.afterReadData(controller, model));
    }

    public static <M, C extends ViewController<?, M>> void beforeWriteData(C controller, M model) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.BEFORE_WRITE_DATA, interceptor -> interceptor.beforeWriteData(controller, model));
    }

    public static <M, C extends ViewController<?, M>> void afterWriteData(C controller, M model) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.AFTER_READ_DATA, interceptor -> interceptor.afterWriteData(controller, model));
    }

    public static <M, C extends ViewController<?, M>> void validateData(C controller, List<Message> messages) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.VALIDATE, interceptor -> interceptor.validateData(controller, messages));
    }

    public static <M, C extends ViewController<?, M>> boolean isDataAclEnforceable(C controller) {
        return ControllersRegistry.anyMatch(controller, null, ControllerInterceptor::isDataAclEnforceable);
    }

    public static <M, C extends ViewController<?, M>> void enforceDataAcl(C controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        ControllersRegistry.process(controller, ControllerEventHandler.EventType.ENFORCE_DATA_ACL, interceptor -> interceptor.enforceDataAcl(controller, rootController, deniedPermissions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <M, C extends ViewController<?, M>> void process(C controller, ControllerEventHandler.EventType eventType, Consumer<ControllerInterceptor<M, C>> callback) {
        ArrayList interceptors = null;
        Map<String, List<ControllerInterceptor<?, ?>>> map = INTERCEPTORS;
        synchronized (map) {
            List<ControllerInterceptor<?, ?>> list = INTERCEPTORS.get(controller.getClass().getName());
            if (list != null) {
                interceptors = new ArrayList(list);
            }
        }
        if (interceptors != null) {
            interceptors.forEach(callback);
        }
        if (eventType != null) {
            ArrayList<ControllerEventHandler> handlers = null;
            Map<ViewController<?, ?>, List<ControllerEventHandler>> map2 = HANDLERS;
            synchronized (map2) {
                List<ControllerEventHandler> list = HANDLERS.get(controller);
                if (list != null) {
                    handlers = new ArrayList<ControllerEventHandler>(list);
                }
            }
            if (handlers != null) {
                handlers.forEach(handler -> handler.handle(eventType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <M, C extends ViewController<?, M>> boolean anyMatch(C controller, ControllerEventHandler.EventType eventType, Predicate<ControllerInterceptor<M, C>> callback) {
        ArrayList interceptors = null;
        Map<String, List<ControllerInterceptor<?, ?>>> map = INTERCEPTORS;
        synchronized (map) {
            List<ControllerInterceptor<?, ?>> list = INTERCEPTORS.get(controller.getClass().getName());
            if (list != null) {
                interceptors = new ArrayList(list);
            }
        }
        boolean result = interceptors != null ? interceptors.stream().anyMatch(callback) : false;
        if (eventType != null) {
            ArrayList<ControllerEventHandler> handlers = null;
            Map<ViewController<?, ?>, List<ControllerEventHandler>> map2 = HANDLERS;
            synchronized (map2) {
                List<ControllerEventHandler> list = HANDLERS.get(controller);
                if (list != null) {
                    handlers = new ArrayList<ControllerEventHandler>(list);
                }
            }
            if (handlers != null) {
                handlers.forEach(handler -> handler.handle(eventType));
            }
        }
        return result;
    }

    private ControllersRegistry() {
    }
}

