/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cards;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javafx.animation.PauseTransition;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

class CardPane
extends TitledPane {
    private final Card<?> card;
    private final Pane titleParentPane = new AnchorPane();
    private Pane actionsPane;

    CardPane(Card<?> crd) {
        this.card = crd;
        CustomLabel titleLabel = new CustomLabel();
        titleLabel.textProperty().bind((ObservableValue)this.card.captionProperty());
        FxUtil.addListener(this.card.helpProperty(), (obj, o, n) -> {
            if (n == null) {
                titleLabel.setGraphic(null);
            } else {
                titleLabel.setGraphic((Node)Buttons.quickHelpButton(((Supplier)n)::get));
            }
            Styles.manageStyle((Styleable)titleLabel, "hasTooltip", n != null);
        });
        HBox titleLabelPane = new HBox(new Node[]{titleLabel});
        titleLabelPane.getStyleClass().add((Object)"title-label-pane");
        if (this.card.isCollapsible()) {
            Button ruler = new Button();
            ruler.setGraphic((Node)new IconNode(StandardIconShapes.RULER_14X14, (Styleable)this, StandardIconIntentions.RULER_BUTTON_ACTION, (Styleable)this.titleParentPane));
            ruler.getStyleClass().add((Object)"xtrip-ruler");
            ruler.setOnAction(evt -> this.setExpanded(!this.isExpanded()));
            titleLabelPane.getChildren().add((Object)ruler);
        }
        this.titleParentPane.getChildren().addAll((Object[])new Node[]{titleLabelPane});
        this.titleParentPane.minWidthProperty().bind((ObservableValue)this.widthProperty());
        AnchorPane.setLeftAnchor((Node)titleLabelPane, (Double)Double.MIN_VALUE);
        this.titleParentPane.setOnMouseClicked(evt -> {
            if (evt.isAltDown() && evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                CustomContextMenu cm = new CustomContextMenu();
                cm.getItems().addAll(this.collectAdminTools());
                cm.show((Node)this.titleParentPane, evt.getScreenX(), evt.getScreenY());
                evt.consume();
                return;
            }
        });
        this.setGraphic((Node)this.titleParentPane);
        Styles.manageStyle((Styleable)this, "incollapsible", !this.card.isCollapsible());
        this.rebuildActionsPane();
        if (this.card.isCollapsible()) {
            this.setCollapsible(true);
            this.setExpanded(!this.card.isCollapsed());
            this.card.collapsedProperty().addListener((obj, oldValue, newValue) -> this.setExpanded(newValue == false));
            this.expandedProperty().addListener((obj, oldValue, newValue) -> {
                if (this.card.isAdaptiveHeight()) {
                    this.setMaxHeight(newValue != false ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY);
                }
                this.card.setCollapsed(newValue == false);
                this.revalidateActions();
            });
        } else {
            this.setCollapsible(false);
            this.setExpanded(true);
        }
        this.setContent(this.createContent());
    }

    private Node createContent() {
        StackPane result = new StackPane();
        result.getStyleClass().add((Object)"content-pane");
        result.setVisible(!this.isCollapsible());
        FxUtil.addListener(result.visibleProperty(), (s, o, n) -> {
            if (n.booleanValue()) {
                result.getChildren().setAll((Object[])new Node[]{this.card.getContent()});
                PauseTransition transition = new PauseTransition(TitledPaneSkin.TRANSITION_DURATION.add(Duration.millis((double)100.0)));
                transition.setOnFinished(evt -> {
                    ScrollPane sp = (ScrollPane)UiUtil.lookupNode((Node)result, nd -> nd instanceof ScrollPane);
                    if (sp != null) {
                        UiUtil.scrollToVisible(sp, (Node)result);
                    }
                });
                transition.playFromStart();
            } else {
                result.getChildren().clear();
            }
        });
        return result;
    }

    void rebuildActionsPane() {
        if (this.card.getActions().isEmpty()) {
            if (this.actionsPane != null) {
                this.titleParentPane.getChildren().remove((Object)this.actionsPane);
                this.actionsPane = null;
            }
            return;
        }
        if (this.actionsPane == null) {
            this.actionsPane = new HBox();
            this.actionsPane.getStyleClass().add((Object)"actions-pane");
            this.titleParentPane.getChildren().addAll((Object[])new Node[]{this.actionsPane});
            AnchorPane.setRightAnchor((Node)this.actionsPane, (Double)Double.MIN_VALUE);
        }
        ArrayList sortedActions = new ArrayList((Collection<CardAction<?>>)this.card.getActions());
        Collections.sort(sortedActions, (action1, action2) -> {
            if (action1.getWeight() != action2.getWeight()) {
                return action1.getWeight() < action2.getWeight() ? -1 : 1;
            }
            return action1.getName(this.card).compareTo(action2.getName(this.card));
        });
        ArrayList<Hyperlink> items = new ArrayList<Hyperlink>(sortedActions.size());
        for (CardAction cardAction : sortedActions) {
            Hyperlink link = new Hyperlink();
            link.setUserData((Object)cardAction);
            link.setOnMouseClicked(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getClickCount() != 1 || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction((Control)link, action, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
            link.setOnKeyPressed(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getCode() != KeyCode.ENTER) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction((Control)link, action, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
            items.add(link);
        }
        this.actionsPane.getChildren().setAll(items);
    }

    private void executeAction(Control source, CardAction<?> action, boolean alt) {
        AclQuery query = action.getACLQuery(this.card);
        if (query == null) {
            action.execute(source, this.card, alt);
            return;
        }
        Notifications.get().submitTask(() -> {
            String id = "action";
            Set<String> grantedIds = FxAclUtil.applyACL(Collections.singletonMap(id, query));
            FxUtil.submitToFxThread(() -> {
                if (grantedIds.contains(id)) {
                    action.execute(source, this.card, alt);
                } else {
                    StandardNotifications.PERMISSION_DENIED.show(Messages.General_Not_enough_permissions_for_operation + ' ' + action.getDescription(this.card));
                }
            });
        }, ObservableMutex.lookup((Node)this));
    }

    void revalidateActions() {
        if (this.actionsPane == null || this.actionsPane.getChildren().isEmpty()) {
            return;
        }
        for (Node node : this.actionsPane.getChildren()) {
            Hyperlink link = (Hyperlink)node;
            CardAction action = (CardAction)link.getUserData();
            link.setText(action.getName(this.card));
            UiUtil.setTooltip((Node)link, action.getDescription(this.card));
            link.setDisable(!action.isEnabled(this.card));
        }
    }

    private List<MenuItem> collectAdminTools() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        CustomMenuItem item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(DevTools.getStructuredInfo(this.card));
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Card UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        result.add((MenuItem)item);
        return result;
    }
}

