/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.cells;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.BaseCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.common.model.Xeption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;

public class CellsContainer
extends GridPane
implements DevTool {
    private final ObservableList<CellsContainerColumn> columns = FXCollections.observableArrayList();
    private final ObservableList<BaseCell> cells = FXCollections.observableArrayList();
    private final ObservableList<BaseCell> forbiddenCells = FXCollections.observableArrayList();

    public CellsContainer() {
        this.getStyleClass().add((Object)"cells-container");
        this.columns.addListener(obj -> this.reflow());
        this.cells.addListener(obj -> this.reflow());
        this.forbiddenCells.addListener(obj -> this.reflow());
        this.sceneProperty().addListener((s, o, n) -> {
            if (n != null) {
                this.reflow();
            }
        });
    }

    public ObservableList<CellsContainerColumn> getColumns() {
        return this.columns;
    }

    public ObservableList<BaseCell> getCells() {
        return this.cells;
    }

    public ObservableList<BaseCell> getForbiddenCells() {
        return this.forbiddenCells;
    }

    private void populateCellData(SimpleCell cell, Label label) {
        Styles.manageStyle((Styleable)label, "hasTooltip", cell.helpProperty().get() != null);
        if (cell.helpProperty().get() == null) {
            label.setGraphic(null);
        } else {
            label.setGraphic((Node)Buttons.quickHelpButton(((Supplier)((Supplier)cell.helpProperty().get()))::get));
        }
        GridPane.setHalignment((Node)label, (HPos)cell.getAlignment().getHpos());
        GridPane.setValignment((Node)label, (VPos)cell.getAlignment().getVpos());
    }

    void reflow() {
        if (this.getScene() == null) {
            return;
        }
        if (this.columns.isEmpty() || this.cells.isEmpty()) {
            this.getColumnConstraints().clear();
            this.getRowConstraints().clear();
            this.getChildren().clear();
            return;
        }
        ArrayList<ColumnConstraints> colConstraints = new ArrayList<ColumnConstraints>(this.columns.size());
        for (CellsContainerColumn col : this.columns) {
            col.setContainer(this);
            ColumnConstraints cc = new ColumnConstraints();
            if (col.getPrefWidth() != null) {
                cc.setPercentWidth(col.getPrefWidth().doubleValue());
            }
            colConstraints.add(cc);
        }
        ArrayList<RowConstraints> rowConstraints = new ArrayList<RowConstraints>();
        ArrayList children = new ArrayList(this.cells.size());
        int row = 0;
        int col = 0;
        int[] rowSpans = new int[this.columns.size()];
        boolean newRow = true;
        int size = this.cells.size();
        block1: for (int index = 0; index < size; ++index) {
            Object cellNode;
            BaseCell cell = (BaseCell)this.cells.get(index);
            cell.setContainer(this);
            if (cell.isHidden() || this.forbiddenCells.contains((Object)cell)) continue;
            if (newRow) {
                col = -1;
                RowConstraints rc = new RowConstraints(-1.0, -1.0, -1.0);
                rc.setValignment(VPos.CENTER);
                rowConstraints.add(rc);
                newRow = false;
                for (int i = 0; i < rowSpans.length; ++i) {
                    int span = rowSpans[i];
                    if (span > 0) {
                        --span;
                    }
                    if (span != 0 || col != -1) continue;
                    col = i;
                }
            }
            if (cell instanceof SimpleCell) {
                SimpleCell simpleCell = (SimpleCell)cell;
                CustomLabel label = new CustomLabel();
                label.getStyleClass().add((Object)"simple-cell");
                label.setMaxHeight(Double.MAX_VALUE);
                label.textProperty().bind((ObservableValue)simpleCell.valueProperty());
                label.getStyleClass().add((Object)simpleCell.getStyle().getCssClass());
                if (cell.getRowSpan() > 1) {
                    label.setWrapText(true);
                }
                InvalidationListener listener = src -> this.populateCellData(simpleCell, label);
                simpleCell.helpProperty().addListener(listener);
                simpleCell.alignmentProperty().addListener(listener);
                this.populateCellData(simpleCell, label);
                cellNode = label;
            } else if (cell instanceof ComplexCell) {
                cellNode = ((ComplexCell)cell).getPayload();
                VBox.setVgrow(cellNode, (Priority)Priority.ALWAYS);
            } else {
                throw Xeption.forDeveloper((String)"unsupported cell class {0}", (Object[])new Object[]{cell.getClass().getName()});
            }
            Styles.addStyle(cellNode, "grid-cell");
            if (cellNode instanceof Region) {
                ((Region)cellNode).setMaxWidth(Double.MAX_VALUE);
            }
            cellNode.pseudoClassStateChanged(Styles.LEFT_PSEUDOCLASS, col == 0);
            cellNode.pseudoClassStateChanged(Styles.TOP_PSEUDOCLASS, row == 0);
            cellNode.pseudoClassStateChanged(Styles.RIGHT_PSEUDOCLASS, col + cell.getColSpan() >= this.columns.size());
            GridPane.setConstraints(cellNode, (int)col, (int)row);
            GridPane.setHgrow(cellNode, (Priority)Priority.ALWAYS);
            if (cell.getColSpan() > 1) {
                GridPane.setColumnSpan(cellNode, (Integer)cell.getColSpan());
            }
            if (cell.getRowSpan() > 1) {
                GridPane.setRowSpan(cellNode, (Integer)cell.getRowSpan());
                rowSpans[col] = cell.getRowSpan();
            }
            children.add(cellNode);
            if (cell.getColSpan() == Integer.MAX_VALUE || col + cell.getColSpan() - 1 >= this.columns.size() - 1) {
                newRow = true;
                ++row;
                continue;
            }
            for (int i = col += cell.getColSpan(); i < rowSpans.length; ++i) {
                if (rowSpans[i] != 0) continue;
                col = i;
                continue block1;
            }
        }
        for (Node node : children) {
            int rowIdx = GridPane.getRowIndex((Node)node);
            node.pseudoClassStateChanged(Styles.BOTTOM_PSEUDOCLASS, newRow ? rowIdx == row - 1 : rowIdx == row);
        }
        this.getColumnConstraints().setAll(colConstraints);
        this.getRowConstraints().setAll(rowConstraints);
        this.getChildren().setAll(children);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>(ControllersRegistry.buildDevToolsFor(CellsContainer.this.getClass().getName() + "Controller"));
                result.addAll((Collection<DevTool>)CellsContainer.this.getCells());
                return result;
            }

            @Override
            public String getInfo() {
                return CellsContainer.this.getClass().getSimpleName() + " [CellsContainer]";
            }
        };
    }
}

