/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.grid;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCellAction;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class GridCell<N extends Node>
implements DevTool {
    public static final String CELL_ID_PROPERTY_NAME = "CELL_ID";
    public static final GridCell<?> NEW_ROW_MARKER = new GridCell<Node>(){

        @Override
        public void setCaption(String value) {
        }

        @Override
        public void setHelp(Supplier<QuickHelp> value) {
        }

        @Override
        public void setPayload(Node value) {
        }

        @Override
        public void setColSpan(int value) {
        }

        @Override
        public void setRowSpan(int value) {
        }

        @Override
        public void setHidden(boolean value) {
        }

        @Override
        void setContainer(GridContainer value) {
        }
    };
    private String caption;
    private Supplier<QuickHelp> help;
    private N payload;
    private int colSpan = 1;
    private int rowSpan = 1;
    private boolean hidden;
    protected GridContainer container;
    private final ObservableList<GridCellAction<N>> actions = FXCollections.observableArrayList();
    private HBox captionPane;
    private HBox actionsPane;

    GridCell() {
    }

    public GridCell(N pl) {
        this(null, pl);
    }

    public GridCell(String capt, N pl) {
        this.caption = capt;
        this.payload = (Node)Objects.requireNonNull(pl);
        this.actions.addListener(src -> this.updateCaptionPane());
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
        this.updateCaptionPane();
    }

    public void setHelp(Supplier<QuickHelp> value) {
        this.help = value;
        this.updateCaptionPane();
    }

    public N getPayload() {
        return this.payload;
    }

    public void setPayload(N value) {
        this.payload = (Node)Objects.requireNonNull(value);
        if (this.container != null && !this.hidden) {
            this.container.reflow();
        }
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("column span should be positive");
        }
        if (this.colSpan == value) {
            return;
        }
        this.colSpan = value;
        if (this.container != null && !this.hidden) {
            this.container.reflow();
        }
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("row span should be positive");
        }
        if (this.rowSpan == value) {
            return;
        }
        this.rowSpan = value;
        if (this.container != null && !this.hidden) {
            this.container.reflow();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean value) {
        if (this.hidden == value) {
            return;
        }
        this.hidden = value;
        if (this.container != null) {
            this.container.reflow();
        }
    }

    void setContainer(GridContainer value) {
        this.container = value;
    }

    void setCaptionPane(HBox value) {
        this.captionPane = value;
        this.updateCaptionPane();
    }

    private void updateCaptionPane() {
        if (this.captionPane == null) {
            return;
        }
        CustomLabel label = null;
        if (!TextUtil.isBlank((String)this.caption)) {
            label = new CustomLabel(this.caption);
            if (this.help != null) {
                label.setGraphic((Node)Buttons.quickHelpButton(this.help::get));
                Styles.manageStyle((Styleable)label, "hasTooltip", true);
            }
        }
        this.createActionsPane();
        this.revalidateActions();
        if (label == null && this.actionsPane == null) {
            this.captionPane.getChildren().clear();
        } else if (label == null) {
            this.captionPane.getChildren().setAll((Object[])new Node[]{this.actionsPane});
        } else if (this.actionsPane == null) {
            this.captionPane.getChildren().setAll((Object[])new Node[]{label});
        } else {
            this.captionPane.getChildren().setAll((Object[])new Node[]{label, this.actionsPane});
        }
    }

    private void createActionsPane() {
        if (this.actions.isEmpty()) {
            this.actionsPane = null;
            return;
        }
        if (this.actionsPane == null) {
            this.actionsPane = new HBox();
            HBox.setHgrow((Node)this.actionsPane, (Priority)Priority.ALWAYS);
            this.actionsPane.getStyleClass().add((Object)"actions-pane");
        }
        List actionNodes = this.actions.stream().sorted((action1, action2) -> {
            if (action1.getWeight() != action2.getWeight()) {
                return action1.getWeight() < action2.getWeight() ? -1 : 1;
            }
            return action1.getName(this).compareTo(action2.getName(this));
        }).map(action -> {
            Hyperlink link = new Hyperlink();
            link.setUserData(action);
            link.setOnMouseClicked(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getClickCount() != 1 || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction((Control)link, (GridCellAction<N>)action, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
            link.setOnKeyPressed(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (evt.getCode() != KeyCode.ENTER) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction((Control)link, (GridCellAction<N>)action, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
            return link;
        }).collect(Collectors.toList());
        this.actionsPane.getChildren().setAll(actionNodes);
    }

    private void executeAction(Control source, GridCellAction<N> action, boolean alt) {
        AclQuery query = action.getACLQuery(this);
        if (query == null) {
            action.execute(source, this, alt);
            return;
        }
        Notifications.get().submitTask(() -> {
            String id = "action";
            Set<String> grantedIds = FxAclUtil.applyACL(Collections.singletonMap(id, query));
            FxUtil.submitToFxThread(() -> {
                if (grantedIds.contains(id)) {
                    action.execute(source, this, alt);
                } else {
                    StandardNotifications.PERMISSION_DENIED.show(Messages.General_Not_enough_permissions_for_operation + ' ' + action.getDescription(this));
                }
            });
        }, ObservableMutex.lookup((Node)this.actionsPane));
    }

    public ObservableList<GridCellAction<N>> getActions() {
        return this.actions;
    }

    public void revalidateActions() {
        if (this.actionsPane == null || this.actionsPane.getChildren().isEmpty()) {
            return;
        }
        for (Node node : this.actionsPane.getChildren()) {
            Hyperlink link = (Hyperlink)node;
            GridCellAction action = (GridCellAction)link.getUserData();
            link.setText(action.getName(this));
            UiUtil.setTooltip((Node)link, action.getDescription(this));
            link.setDisable(!action.isEnabled(this));
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                ArrayList<DevTool> result = new ArrayList<DevTool>();
                for (final GridCellAction action : GridCell.this.getActions()) {
                    result.add(() -> new DevToolItem(){

                        @Override
                        public Collection<?> getSubItems() {
                            return Collections.emptyList();
                        }

                        @Override
                        public String getInfo() {
                            return "A " + MiscUtil.getSimpleClassName(action.getClass()) + " [" + action.getName(GridCell.this) + ']';
                        }
                    });
                }
                result.add((DevTool)GridCell.this.getPayload());
                return result;
            }

            @Override
            public String getInfo() {
                String result = GridCell.this.getClass().getSimpleName() + " [" + GridCell.this.getCaption() + ']';
                if (GridCell.this.isHidden()) {
                    result = result + " [hidden]";
                }
                if (GridCell.this.container != null && GridCell.this.container.getForbiddenCells().contains((Object)GridCell.this)) {
                    result = result + " [forbidden]";
                }
                return result;
            }
        };
    }
}

