/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.container.tiles;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

class TilePane<C extends Node, F extends Node>
extends StackPane {
    private final Tile<C, F> tile;
    private final StackPane contentPane;
    private final CustomContextMenu menu = new CustomContextMenu();
    private ToolBar actionsBar;
    private HBox controlsPane;
    private Button navButton;
    private Button prevButton;
    private Button nextButton;
    private Button expandButton;

    TilePane(Tile<C, F> aTile, boolean expanded) {
        this.tile = aTile;
        GridPane.setValignment((Node)this, (VPos)VPos.TOP);
        BorderPane captionPane = new BorderPane();
        captionPane.getStyleClass().add((Object)"tile-caption-pane");
        CustomLabel caption = new CustomLabel();
        BorderPane.setAlignment((Node)caption, (Pos)Pos.CENTER_LEFT);
        caption.textProperty().bind((ObservableValue)this.tile.captionProperty());
        FxUtil.addListener(this.tile.helpProperty(), (obj, o, n) -> {
            if (n == null) {
                caption.setGraphic(null);
            } else {
                caption.setGraphic((Node)Buttons.quickHelpButton(((Supplier)n)::get));
            }
            Styles.manageStyle((Styleable)caption, "hasTooltip", n != null);
        });
        captionPane.setCenter((Node)caption);
        this.contentPane = new StackPane();
        this.contentPane.getStyleClass().add((Object)"tile-content-pane");
        VBox.setVgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
        VBox layoutBox = new VBox();
        layoutBox.getStyleClass().add((Object)"tile-pane");
        layoutBox.getChildren().addAll((Object[])new Node[]{captionPane, this.createActionsPane(), this.contentPane});
        this.getStyleClass().add((Object)"tile-pane-shadow");
        this.getChildren().add((Object)layoutBox);
        captionPane.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            if (evt.isAltDown() && evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                CustomContextMenu cm = new CustomContextMenu();
                cm.getItems().addAll(this.collectAdminTools());
                cm.show((Node)captionPane, evt.getScreenX(), evt.getScreenY());
                evt.consume();
                return;
            }
        });
        this.pseudoClassStateChanged(Styles.EXPANDED_PSEUDOCLASS, expanded);
        if ((this.tile.getSpace().superCompactMode || this.tile.getCompactNode() != null) && this.tile.getFullNode() != null) {
            this.controlsPane = new HBox();
            captionPane.setRight((Node)this.controlsPane);
            captionPane.setOnMouseClicked(evt -> {
                if (evt.getClickCount() == 2) {
                    this.tile.getSpace().setExpanded(this.getTile(), !expanded);
                    evt.consume();
                }
            });
        }
        this.updateControlsPane(expanded);
        if (expanded) {
            ScrollPane scrollPane = new ScrollPane(this.tile.getFullNode());
            scrollPane.getStyleClass().add((Object)"edge-to-edge");
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            this.contentPane.getChildren().add((Object)scrollPane);
        } else if (this.tile.getCompactNode() != null) {
            this.contentPane.getChildren().add(this.tile.getCompactNode());
        }
        layoutBox.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, this.contentPane.getChildren().isEmpty());
    }

    void updateControlsPane(boolean expanded) {
        if (this.controlsPane == null) {
            return;
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (expanded) {
            Tile<?, ?> nextTile;
            Tile<?, ?> prevTile;
            if (this.navButton == null) {
                this.navButton = new Button();
                this.navButton.setGraphic((Node)new IconNode(StandardIconShapes.TILE_LIST_14x14, (Styleable)this.navButton, StandardIconIntentions.TILE_LIST_BUTTON_ACTION, (Styleable)this.navButton));
                this.navButton.getStyleClass().add((Object)"xtrip-button");
                UiUtil.setTooltip((Node)this.navButton, Messages.General_Choose_block);
                this.navButton.setOnAction(evt -> this.showNavList((Region)this.navButton));
            }
            buttons.add(this.navButton);
            if (this.prevButton == null) {
                this.prevButton = new Button();
                this.prevButton.setGraphic((Node)new IconNode(StandardIconShapes.TILE_PREV_14x14, (Styleable)this.prevButton, StandardIconIntentions.TILE_PREV_BUTTON_ACTION, (Styleable)this.prevButton));
                this.prevButton.getStyleClass().add((Object)"xtrip-button");
                this.prevButton.setOnAction(evt -> {
                    Tile<?, ?> prevTile = this.findPrevExpandable();
                    if (prevTile == null) {
                        return;
                    }
                    this.tile.getSpace().setExpanded(prevTile, true);
                });
                this.prevButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TilePane.this.getTile().expandedProperty(), TilePane.this.getTile().getSpace().mosaicPane.getChildren()});
                    }

                    protected boolean computeValue() {
                        return TilePane.this.findPrevExpandable() == null;
                    }
                });
            }
            UiUtil.setTooltip((Node)this.prevButton, (prevTile = this.findPrevExpandable()) == null ? null : Messages.General_Previous_block + ' ' + prevTile.getCaption());
            buttons.add(this.prevButton);
            if (this.nextButton == null) {
                this.nextButton = new Button();
                this.nextButton.setGraphic((Node)new IconNode(StandardIconShapes.TILE_NEXT_14x14, (Styleable)this.nextButton, StandardIconIntentions.TILE_NEXT_BUTTON_ACTION, (Styleable)this.nextButton));
                this.nextButton.getStyleClass().add((Object)"xtrip-button");
                this.nextButton.setOnAction(evt -> {
                    Tile<?, ?> nextTile = this.findNextExpandable();
                    if (nextTile == null) {
                        return;
                    }
                    this.tile.getSpace().setExpanded(nextTile, true);
                });
                this.nextButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
                    {
                        this.bind(new Observable[]{TilePane.this.getTile().expandedProperty(), TilePane.this.getTile().getSpace().mosaicPane.getChildren()});
                    }

                    protected boolean computeValue() {
                        return TilePane.this.findNextExpandable() == null;
                    }
                });
            }
            UiUtil.setTooltip((Node)this.nextButton, (nextTile = this.findNextExpandable()) == null ? null : Messages.General_Next_block + ' ' + nextTile.getCaption());
            buttons.add(this.nextButton);
        }
        if (this.expandButton == null) {
            this.expandButton = new Button();
            this.expandButton.setGraphic((Node)new IconNode(StandardIconShapes.TILE_EXPAND_14x14, (Styleable)this, StandardIconIntentions.TILE_EXPAND_BUTTON_ACTION, (Styleable)this));
            this.expandButton.getStyleClass().add((Object)"xtrip-button");
            this.expandButton.setOnAction(evt -> this.tile.getSpace().setExpanded(this.getTile(), !expanded));
        }
        buttons.add(this.expandButton);
        UiUtil.setTooltip((Node)this.expandButton, expanded ? Messages.General_Collapse_block : Messages.General_Expand_block);
        this.controlsPane.getChildren().setAll(buttons);
    }

    protected Tile<?, ?> findPrevExpandable() {
        List<Tile<?, ?>> tiles = this.collectExpandableTiles();
        int idx = tiles.indexOf(this.getTile());
        return idx <= 0 ? null : tiles.get(idx - 1);
    }

    protected Tile<?, ?> findNextExpandable() {
        List<Tile<?, ?>> tiles = this.collectExpandableTiles();
        int idx = tiles.indexOf(this.getTile());
        return idx == tiles.size() - 1 ? null : tiles.get(idx + 1);
    }

    private void showNavList(Region anchor) {
        if (!this.menu.isShowing()) {
            ArrayList<CustomMenuItem> items = new ArrayList<CustomMenuItem>();
            for (Tile<?, ?> tl : this.collectExpandableTiles()) {
                if (tl.equals(this.tile)) continue;
                CustomMenuItem menuItem = new CustomMenuItem(tl.getCaption());
                menuItem.setOnAction(event -> this.tile.getSpace().setExpanded(tl, true));
                items.add(menuItem);
            }
            this.menu.getItems().setAll(items);
            this.menu.show((Node)anchor, Side.BOTTOM, 0.0, 0.0);
        } else {
            this.menu.hide();
        }
    }

    private List<Tile<?, ?>> collectExpandableTiles() {
        TilesSpace space = this.tile.getSpace();
        ArrayList result = new ArrayList(space.tiles.size());
        for (Tile tl : space.tiles) {
            if (!space.isVisible(tl) || tl.getFullNode() == null) continue;
            result.add(tl);
        }
        Collections.sort(result, (tile1, tile2) -> space.settings.getPosition(tile1.getId()) - space.settings.getPosition(tile2.getId()));
        return result;
    }

    private Node createActionsPane() {
        StackPane result = new StackPane();
        result.getStyleClass().add((Object)"tile-actions-pane");
        this.getTile().getActions().addListener(src -> {
            result.getChildren().clear();
            this.populateActions();
            this.revalidateActions();
            if (this.actionsBar != null && !this.actionsBar.getItems().isEmpty()) {
                result.getChildren().setAll((Object[])new Node[]{this.actionsBar});
            }
        });
        this.populateActions();
        this.revalidateActions();
        if (this.actionsBar != null && !this.actionsBar.getItems().isEmpty()) {
            result.getChildren().setAll((Object[])new Node[]{this.actionsBar});
        }
        return result;
    }

    private void populateActions() {
        if (this.getTile().getActions().isEmpty()) {
            if (this.actionsBar != null) {
                this.actionsBar = null;
            }
            return;
        }
        if (this.actionsBar == null) {
            this.actionsBar = new ToolBar();
        }
        ArrayList<TileAction<C, F>> sortedActions = new ArrayList<TileAction<C, F>>(this.getTile().getActions());
        Collections.sort(sortedActions, (action1, action2) -> {
            if (action1.getWeight() != action2.getWeight()) {
                return action1.getWeight() < action2.getWeight() ? -1 : 1;
            }
            return action1.getName(this.getTile()).compareTo(action2.getName(this.getTile()));
        });
        ArrayList<StackPane> items = new ArrayList<StackPane>(sortedActions.size());
        for (TileAction tileAction : sortedActions) {
            Hyperlink link = new Hyperlink();
            link.setUserData((Object)tileAction);
            StackPane wrap = new StackPane();
            wrap.getStyleClass().add((Object)"action-tile");
            wrap.getChildren().add((Object)link);
            link.disabledProperty().addListener((obj, o, n) -> wrap.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"disabled"), n.booleanValue()));
            items.add(wrap);
            link.setOnAction(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (wrap.getParent() instanceof HBox) {
                    return;
                }
                this.executeAction(action, (Control)this.actionsBar, false);
            });
            link.setOnMouseClicked(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (!(wrap.getParent() instanceof HBox)) {
                    return;
                }
                if (evt.getClickCount() != 1 || evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction(action, (Control)link, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
            link.setOnKeyPressed(evt -> {
                if (link.isDisabled()) {
                    return;
                }
                if (!(wrap.getParent() instanceof HBox)) {
                    return;
                }
                if (evt.getCode() != KeyCode.ENTER) {
                    return;
                }
                evt.consume();
                link.requestFocus();
                this.executeAction(action, (Control)link, evt.isAltDown() && evt.isControlDown() && evt.isShiftDown());
            });
        }
        this.actionsBar.getItems().setAll(items);
    }

    private void executeAction(TileAction<C, F> action, Control source, boolean alt) {
        Tile tl = this.getTile();
        AclQuery query = action.getACLQuery(tl);
        if (query == null) {
            action.execute(source, tl, alt);
            return;
        }
        Notifications.get().submitTask(() -> {
            String id = "action";
            Set<String> grantedIds = FxAclUtil.applyACL(Collections.singletonMap(id, query));
            FxUtil.submitToFxThread(() -> {
                if (grantedIds.contains(id)) {
                    action.execute(source, tl, alt);
                } else {
                    StandardNotifications.PERMISSION_DENIED.show(Messages.General_Not_enough_permissions_for_operation + ' ' + action.getDescription(tl));
                }
            });
        }, ObservableMutex.lookup((Node)this));
    }

    Tile<C, F> getTile() {
        return this.tile;
    }

    void revalidateActions() {
        if (this.actionsBar == null || this.actionsBar.getItems().isEmpty()) {
            return;
        }
        ObservableMutex mutex = ObservableMutex.lookup((Node)this);
        boolean mutexAcquired = mutex == null ? false : mutex.isAcquired();
        for (Node node : this.actionsBar.getItems()) {
            Hyperlink link = (Hyperlink)node.lookup("Hyperlink");
            try {
                TileAction action = (TileAction)link.getUserData();
                link.setText(action.getName(this.getTile()));
                UiUtil.setTooltip((Node)link, action.getDescription(this.getTile()));
                link.setDisable(mutexAcquired || !action.isEnabled(this.getTile()));
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                link.setDisable(true);
            }
        }
    }

    private List<MenuItem> collectAdminTools() {
        HashMap<String, EventHandler> map = new HashMap<String, EventHandler>();
        map.put("UI Technical Data", evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(DevTools.getStructuredInfo(this.tile));
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Tile UI Technical Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        Consumer<Map<String, EventHandler<ActionEvent>>> builder = this.tile.getAdminToolsBuilder();
        if (builder != null) {
            builder.accept(map);
        }
        return map.entrySet().stream().sorted((lhs, rhs) -> ((String)lhs.getKey()).compareTo((String)rhs.getKey())).map(entry -> {
            CustomMenuItem item = new CustomMenuItem((String)entry.getKey());
            item.setOnAction((EventHandler)entry.getValue());
            return item;
        }).collect(Collectors.toList());
    }
}

